/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.solarnetwork.node.backup.Backup;
import net.solarnetwork.node.backup.BackupIdentity;
import net.solarnetwork.node.backup.BackupService;
import net.solarnetwork.node.backup.SimpleBackupIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackupServiceSupport
implements BackupService {
    public static final String BACKUP_KEY_DATE_FORMAT = "yyyyMMdd'T'HHmmss";
    public static final Pattern NODE_AND_DATE_BACKUP_KEY_PATTERN = Pattern.compile("node-(\\d+)-backup-(\\d{8}T\\d{6})(-(\\w+))?");
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static final String MARKED_BACKUP_PROP_KEY = "key";
    private static final String MARKED_BACKUP_PROP_PROPS = "props";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected File defaultBackuprDir() {
        String path = System.getProperty("sn.home", null);
        if (path == null) {
            path = System.getProperty("java.io.tmpdir");
        } else {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + "var/backups";
        }
        return new File(path);
    }

    protected File markedBackupForRestoreFile() {
        return new File(this.defaultBackuprDir(), this.getKey() + ".RESTORE_ON_BOOT");
    }

    protected Date backupDateFromProps(Date date, Map<String, String> props) {
        return this.backupDateFromProps(date, props, NODE_AND_DATE_BACKUP_KEY_PATTERN, BACKUP_KEY_DATE_FORMAT);
    }

    protected Date backupDateFromProps(Date date, Map<String, String> props, Pattern nodeIdAndDatePattern, String dateFormat) {
        Matcher m;
        String backupKey;
        if (date != null) {
            return date;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String string = backupKey = props == null ? null : props.get("BackupKey");
        if (backupKey != null && (m = nodeIdAndDatePattern.matcher(backupKey)).find()) {
            try {
                return sdf.parse(m.group(2));
            }
            catch (ParseException e) {
                this.log.warn("Unable to parse backup date from key [{}]", (Object)backupKey);
            }
        }
        return new Date();
    }

    protected Long backupNodeIdFromProps(Long nodeId, Map<String, String> props) {
        return this.backupNodeIdFromProps(nodeId, props, NODE_AND_DATE_BACKUP_KEY_PATTERN);
    }

    protected Long backupNodeIdFromProps(Long nodeId, Map<String, String> props, Pattern nodeIdAndDatePattern) {
        Matcher m;
        String backupKey;
        if (nodeId != null) {
            return nodeId;
        }
        Long result = 0L;
        String string = backupKey = props == null ? null : props.get("BackupKey");
        if (backupKey != null && (m = nodeIdAndDatePattern.matcher(backupKey)).find()) {
            try {
                result = Long.valueOf(m.group(1));
            }
            catch (NumberFormatException e) {
                this.log.warn("Unable to parse node ID from key [{}]", (Object)backupKey);
            }
        }
        return result;
    }

    public static final BackupIdentity identityFromBackupKey(String key) {
        return BackupServiceSupport.identityFromBackupKey(NODE_AND_DATE_BACKUP_KEY_PATTERN, BACKUP_KEY_DATE_FORMAT, key);
    }

    public static final BackupIdentity identityFromBackupKey(Pattern nodeIdAndDatePattern, String dateFormat, String key) {
        Matcher m;
        SimpleBackupIdentity result = null;
        if (key != null && (m = nodeIdAndDatePattern.matcher(key)).find()) {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            try {
                Long nodeId = Long.valueOf(m.group(1));
                Date date = sdf.parse(m.group(2));
                String qualifier = null;
                if (m.groupCount() > 2) {
                    qualifier = m.group(m.groupCount());
                }
                result = new SimpleBackupIdentity(key, date, nodeId, qualifier);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public synchronized boolean markBackupForRestore(Backup backup, Map<String, String> props) {
        File parentDir;
        File markFile = this.markedBackupForRestoreFile();
        if (backup == null) {
            if (markFile.exists()) {
                this.log.info("Clearing marked backup.");
                return markFile.delete();
            }
            return true;
        }
        if (markFile.exists()) {
            this.log.warn("Marked backup exists, will not mark again");
            return false;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(MARKED_BACKUP_PROP_KEY, backup.getKey());
        if (props != null && !props.isEmpty()) {
            data.put(MARKED_BACKUP_PROP_PROPS, props);
        }
        if ((parentDir = markFile.getParentFile()) != null && !parentDir.exists() && !parentDir.mkdirs()) {
            this.log.warn("Failed to create directory {} for backup restore mark file {}", (Object)parentDir, (Object)markFile.getName());
        }
        try {
            OBJECT_MAPPER.writeValue(markFile, data);
            return true;
        }
        catch (IOException e) {
            this.log.warn("Failed to create restore mark file {}", (Object)markFile, (Object)e);
            return false;
        }
    }

    @Override
    public synchronized Backup markedBackupForRestore(Map<String, String> props) {
        File markFile = this.markedBackupForRestoreFile();
        if (markFile.exists()) {
            try {
                Map data = (Map)OBJECT_MAPPER.readValue(markFile, Map.class);
                if (data == null || !data.containsKey(MARKED_BACKUP_PROP_KEY)) {
                    return null;
                }
                String key = (String)data.get(MARKED_BACKUP_PROP_KEY);
                if (props != null && data.get(MARKED_BACKUP_PROP_PROPS) instanceof Map) {
                    Map dataProps = (Map)data.get(MARKED_BACKUP_PROP_PROPS);
                    props.putAll(dataProps);
                }
                return this.backupForKey(key);
            }
            catch (IOException e) {
                this.log.warn("Failed to read restore mark file {}", (Object)markFile, (Object)e);
            }
        }
        return null;
    }
}

