/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.solarnetwork.node.backup.Backup;
import net.solarnetwork.node.backup.BackupInfo;
import net.solarnetwork.node.backup.BackupManager;
import net.solarnetwork.node.backup.BackupResource;
import net.solarnetwork.node.backup.BackupResourceInfo;
import net.solarnetwork.node.backup.BackupResourceIterable;
import net.solarnetwork.node.backup.BackupResourceProvider;
import net.solarnetwork.node.backup.BackupResourceProviderInfo;
import net.solarnetwork.node.backup.BackupService;
import net.solarnetwork.node.backup.BackupServiceInfo;
import net.solarnetwork.node.backup.BackupStatus;
import net.solarnetwork.node.backup.FileSystemBackupService;
import net.solarnetwork.node.backup.PrefixedBackupResourceIterator;
import net.solarnetwork.node.backup.SimpleBackupInfo;
import net.solarnetwork.node.backup.SimpleBackupResourceInfo;
import net.solarnetwork.node.backup.ZipStreamBackupResourceIterable;
import net.solarnetwork.service.DynamicServiceUnavailableException;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicRadioGroupSettingSpecifier;
import net.solarnetwork.support.PrefixedMessageSource;
import net.solarnetwork.util.StringUtils;
import net.solarnetwork.util.UnionIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.FileCopyUtils;

public class DefaultBackupManager
implements BackupManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Collection<BackupService> backupServices;
    private Collection<BackupResourceProvider> resourceProviders;
    private ExecutorService executorService = DefaultBackupManager.defaultExecutorService();
    private int backupRestoreDelaySeconds = 15;
    private String preferredBackupServiceKey = FileSystemBackupService.KEY;

    private static HierarchicalMessageSource getMessageSourceInstance() {
        ResourceBundleMessageSource source = new ResourceBundleMessageSource();
        source.setBundleClassLoader(DefaultBackupManager.class.getClassLoader());
        source.setBasename(DefaultBackupManager.class.getName());
        return source;
    }

    private static ExecutorService defaultExecutorService() {
        return new ThreadPoolExecutor(0, 1, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(3, true));
    }

    public void init() {
        this.scheduleRestore();
    }

    private void scheduleRestore() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean retry = true;
                try {
                    Thread.sleep((long)DefaultBackupManager.this.backupRestoreDelaySeconds * 1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                DefaultBackupManager.this.log.debug("Looking to see if there is a marked backup to restore");
                BackupService backupService = DefaultBackupManager.this.activeBackupService();
                if (backupService != null) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    Backup backup = backupService.markedBackupForRestore(props);
                    if (backup != null) {
                        if (DefaultBackupManager.this.restoreBackupInternal(backup, props) && backupService.markBackupForRestore(null, null)) {
                            retry = false;
                            DefaultBackupManager.this.finishRestore(backup);
                        }
                    } else {
                        retry = false;
                    }
                }
                if (retry) {
                    DefaultBackupManager.this.log.debug("Will retry looking to see if there is a marked backup to restore in {} seconds", (Object)DefaultBackupManager.this.backupRestoreDelaySeconds);
                    DefaultBackupManager.this.scheduleRestore();
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private void finishRestore(Backup backup) {
        this.log.info("Restore from backup {} complete", (Object)backup.getKey());
    }

    public String getSettingUid() {
        return this.getClass().getName();
    }

    public String getDisplayName() {
        return "Backup Manager";
    }

    public MessageSource getMessageSource() {
        HierarchicalMessageSource source = DefaultBackupManager.getMessageSourceInstance();
        HashMap<String, MessageSource> delegates = new HashMap<String, MessageSource>();
        for (BackupService backupService : this.backupServices) {
            delegates.put(backupService.getKey() + ".", backupService.getSettingSpecifierProvider().getMessageSource());
        }
        PrefixedMessageSource ps = new PrefixedMessageSource();
        ps.setDelegates(delegates);
        source.setParentMessageSource((MessageSource)ps);
        return source;
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(20);
        BasicRadioGroupSettingSpecifier serviceSpec = new BasicRadioGroupSettingSpecifier("preferredBackupServiceKey", FileSystemBackupService.KEY);
        TreeMap<String, String> serviceSpecValues = new TreeMap<String, String>();
        for (BackupService service : this.backupServices) {
            serviceSpecValues.put(service.getKey(), service.getSettingSpecifierProvider().getDisplayName());
        }
        serviceSpec.setValueTitles(serviceSpecValues);
        results.add((SettingSpecifier)serviceSpec);
        return results;
    }

    @Override
    public BackupService activeBackupService() {
        BackupService fallback = null;
        for (BackupService service : this.backupServices) {
            if (this.preferredBackupServiceKey.equals(service.getKey())) {
                return service;
            }
            if (!FileSystemBackupService.KEY.equals(service.getKey())) continue;
            fallback = service;
        }
        return fallback;
    }

    @Override
    public Iterable<BackupResource> resourcesForBackup() {
        BackupService service = this.activeBackupService();
        if (service == null) {
            this.log.debug("No BackupService available, can't find resources for backup");
            return Collections.emptyList();
        }
        if (service.getInfo().getStatus() != BackupStatus.Configured) {
            this.log.info("BackupService {} in {} state, can't find resources for backup", (Object)service.getKey(), (Object)service.getInfo().getStatus());
            return Collections.emptyList();
        }
        final ArrayList<PrefixedBackupResourceIterator> resources = new ArrayList<PrefixedBackupResourceIterator>(10);
        for (BackupResourceProvider provider : this.resourceProviders) {
            Iterator<BackupResource> itr = provider.getBackupResources().iterator();
            resources.add(new PrefixedBackupResourceIterator(itr, provider.getKey()));
        }
        return new Iterable<BackupResource>(){

            @Override
            public Iterator<BackupResource> iterator() {
                return new UnionIterator((Collection)resources);
            }
        };
    }

    @Override
    public Backup createBackup() {
        return this.createBackup(null);
    }

    @Override
    public Backup createBackup(Map<String, String> props) {
        BackupService service = this.activeBackupService();
        if (service == null) {
            this.log.info("No active backup service available, cannot perform backup");
            return null;
        }
        BackupServiceInfo info = service.getInfo();
        BackupStatus status = info.getStatus();
        if (status != BackupStatus.Configured && status != BackupStatus.Error) {
            this.log.info("BackupService {} is in the {} state; cannot perform backup", (Object)service.getKey(), (Object)status);
            return null;
        }
        this.log.info("Initiating backup to service {}", (Object)service.getKey());
        Backup backup = service.performBackup(this.resourcesForBackup());
        if (backup != null) {
            this.log.info("Backup {} {} with service {}", new Object[]{backup.getKey(), backup.isComplete() ? "completed" : "initiated", service.getKey()});
        }
        return backup;
    }

    @Override
    public Future<Backup> createAsynchronousBackup() {
        return this.createAsynchronousBackup(null);
    }

    @Override
    public Future<Backup> createAsynchronousBackup(final Map<String, String> props) {
        assert (this.executorService != null);
        return this.executorService.submit(new Callable<Backup>(){

            @Override
            public Backup call() throws Exception {
                return DefaultBackupManager.this.createBackup(props);
            }
        });
    }

    @Override
    public void exportBackupArchive(String backupKey, OutputStream out) throws IOException {
        this.exportBackupArchive(backupKey, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportBackupArchive(String backupKey, OutputStream out, Map<String, String> props) throws IOException {
        BackupService service = this.activeBackupService();
        if (service == null) {
            return;
        }
        Backup backup = service.backupForKey(backupKey);
        if (backup == null) {
            return;
        }
        ZipOutputStream zos = new ZipOutputStream(out);
        try {
            BackupResourceIterable resources = service.getBackupResources(backup);
            for (BackupResource r : resources) {
                zos.putNextEntry(new ZipEntry(r.getBackupPath()));
                FileCopyUtils.copy((InputStream)r.getInputStream(), (OutputStream)new FilterOutputStream(zos){

                    @Override
                    public void close() throws IOException {
                    }
                });
            }
            resources.close();
        }
        finally {
            zos.flush();
            zos.finish();
            zos.close();
        }
    }

    @Override
    public Future<Backup> importBackupArchive(InputStream archive) throws IOException {
        return this.importBackupArchive(archive, null);
    }

    @Override
    public Future<Backup> importBackupArchive(InputStream archive, final Map<String, String> props) throws IOException {
        final BackupService service = this.activeBackupService();
        if (service == null) {
            throw new DynamicServiceUnavailableException("No BackupService available to import backup with");
        }
        final ZipInputStream zin = new ZipInputStream(archive);
        return this.executorService.submit(new Callable<Backup>(){

            @Override
            public Backup call() throws Exception {
                ZipStreamBackupResourceIterable itr = new ZipStreamBackupResourceIterable(zin, props);
                return service.importBackup(null, itr, props);
            }
        });
    }

    @Override
    public void restoreBackup(Backup backup) {
        this.restoreBackup(backup, null);
    }

    @Override
    public void restoreBackup(Backup backup, Map<String, String> props) {
        this.restoreBackupInternal(backup, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean restoreBackupInternal(Backup backup, Map<String, String> props) {
        BackupService service = this.activeBackupService();
        if (service == null) {
            this.log.warn("No BackupService available to restore backup with");
            return false;
        }
        Set providerKeySet = props == null ? null : StringUtils.commaDelimitedStringToSet((String)props.get("ResourceProviderFilter"));
        BackupResourceIterable resources = service.getBackupResources(backup);
        boolean result = true;
        try {
            for (final BackupResource r : resources) {
                final String path = r.getBackupPath();
                this.log.debug("Inspecting backup {} resource {}", (Object)backup.getKey(), (Object)path);
                final int providerIndex = path.indexOf(47);
                if (providerIndex == -1) continue;
                final String providerKey = path.substring(0, providerIndex);
                if (providerKeySet != null && !providerKeySet.isEmpty() && !providerKeySet.contains(providerKey)) {
                    this.log.debug("Skipping backup {} resource {} (provider filtered)", (Object)backup.getKey(), (Object)path);
                    continue;
                }
                boolean resourceHandled = false;
                for (BackupResourceProvider provider : this.resourceProviders) {
                    if (!providerKey.equals(provider.getKey())) continue;
                    this.log.debug("Restoring backup {} resource {}", (Object)backup.getKey(), (Object)path);
                    resourceHandled = provider.restoreBackupResource(new BackupResource(){

                        @Override
                        public String getProviderKey() {
                            return providerKey;
                        }

                        @Override
                        public String getBackupPath() {
                            return path.substring(providerIndex + 1);
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return r.getInputStream();
                        }

                        @Override
                        public long getModificationDate() {
                            return r.getModificationDate();
                        }

                        @Override
                        public String getSha256Digest() {
                            return r.getSha256Digest();
                        }
                    });
                    break;
                }
                if (resourceHandled) continue;
                result = false;
                this.log.warn("Backup {} resource {} could not be restored because no resource provider handled the resource.", (Object)backup.getKey(), (Object)path);
            }
        }
        catch (RuntimeException e) {
            this.log.error("Error restoring backup {}", (Object)backup.getKey(), (Object)e);
        }
        finally {
            try {
                resources.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackupInfo infoForBackup(String key, Locale locale) {
        BackupService service = this.activeBackupService();
        if (service == null) {
            this.log.debug("No BackupService available, can't find resources for backup");
            return null;
        }
        Backup backup = service.backupForKey(key);
        if (backup == null) {
            this.log.debug("No backup avaialble from service {} for key {}", (Object)service.getKey(), (Object)key);
            return null;
        }
        LinkedHashMap<String, BackupResourceProviderInfo> providerInfos = new LinkedHashMap<String, BackupResourceProviderInfo>();
        ArrayList<BackupResourceInfo> resourceInfos = new ArrayList<BackupResourceInfo>();
        BackupResourceIterable resources = null;
        try {
            resources = service.getBackupResources(backup);
            for (BackupResource r : resources) {
                BackupResourceInfo info;
                String providerKey = r.getProviderKey();
                BackupResourceProvider provider = this.providerForKey(providerKey);
                if (provider == null) continue;
                if (!providerInfos.containsKey(providerKey)) {
                    providerInfos.put(providerKey, provider.providerInfo(locale));
                }
                if ((info = provider.resourceInfo(r, locale)) == null) continue;
                String name = info.getName();
                if (name != null && name.startsWith(providerKey)) {
                    name = name.substring(providerKey.length() + 1);
                }
                resourceInfos.add(new SimpleBackupResourceInfo(providerKey, name, info.getDescription()));
            }
        }
        finally {
            if (resources != null) {
                try {
                    resources.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new SimpleBackupInfo(key, backup.getDate(), providerInfos.values(), resourceInfos);
    }

    private BackupResourceProvider providerForKey(String key) {
        Collection<BackupResourceProvider> providers = this.resourceProviders;
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        for (BackupResourceProvider provider : providers) {
            if (!key.equals(provider.getKey())) continue;
            return provider;
        }
        return null;
    }

    public void setBackupServices(Collection<BackupService> backupServices) {
        this.backupServices = backupServices;
    }

    public void setResourceProviders(Collection<BackupResourceProvider> resourceProviders) {
        this.resourceProviders = resourceProviders;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setBackupRestoreDelaySeconds(int backupRestoreDelaySeconds) {
        this.backupRestoreDelaySeconds = backupRestoreDelaySeconds;
    }

    public void setPreferredBackupServiceKey(String preferredBackupServiceKey) {
        this.preferredBackupServiceKey = preferredBackupServiceKey;
    }
}

