/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import net.solarnetwork.node.backup.BackupResource;

public class PrefixedBackupResourceIterator
implements Iterator<BackupResource> {
    private final Iterator<BackupResource> delegate;
    private final String prefix;

    public PrefixedBackupResourceIterator(Iterator<BackupResource> delegate, String prefix) {
        this.delegate = delegate;
        this.prefix = prefix;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public BackupResource next() {
        final BackupResource r = this.delegate.next();
        return new BackupResource(){

            @Override
            public String getBackupPath() {
                return PrefixedBackupResourceIterator.this.prefix + '/' + r.getBackupPath();
            }

            @Override
            public String getProviderKey() {
                return PrefixedBackupResourceIterator.this.prefix;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return r.getInputStream();
            }

            @Override
            public long getModificationDate() {
                return r.getModificationDate();
            }

            @Override
            public String getSha256Digest() {
                return r.getSha256Digest();
            }
        };
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

