/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.backup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import net.solarnetwork.node.backup.BackupResource;
import org.apache.commons.io.input.TeeInputStream;

public class ZipStreamBackupResource
implements BackupResource {
    private final InputStream stream;
    private final ZipEntry entry;
    private final String providerKey;
    private final String path;
    private File tempFile;

    public ZipStreamBackupResource(InputStream stream, ZipEntry entry, String providerKey, String path) {
        this.stream = stream;
        this.entry = entry;
        this.providerKey = providerKey;
        this.path = path;
    }

    @Override
    public String getProviderKey() {
        return this.providerKey;
    }

    @Override
    public String getBackupPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.tempFile != null) {
            return new BufferedInputStream(new FileInputStream(this.tempFile));
        }
        this.tempFile = File.createTempFile(this.entry.getName(), ".tmp");
        final BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
        return new TeeInputStream((InputStream)new FilterInputStream(this.stream){

            @Override
            public void close() throws IOException {
                out.flush();
                out.close();
            }
        }, (OutputStream)out, false);
    }

    @Override
    public long getModificationDate() {
        return this.entry.getTime();
    }

    protected void finalize() throws Throwable {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        super.finalize();
    }

    @Override
    public String getSha256Digest() {
        return null;
    }
}

