/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.solarnetwork.node.dao.TransientSettingDao;

public class DefaultTransientSettingDao
extends ConcurrentHashMap<String, ConcurrentMap<String, Object>>
implements TransientSettingDao {
    private static final long serialVersionUID = -2763340940916793785L;
    public static final int DEFAULT_SETTINGS_INITIAL_CAPACITY = 4;
    public static final float DEFAULT_SETTINGS_LOAD_FACTOR = 0.9f;
    public static final int DEFAULT_SETTINGS_CONCURRENCY_LEVEL = 2;
    private int settingsInitialCapacity = 4;
    private float settingsLoadFactor = 0.9f;
    private int settingsConcurrencyLevel = 2;

    public DefaultTransientSettingDao() {
        this(64, 0.8f, Runtime.getRuntime().availableProcessors() + 1);
    }

    public DefaultTransientSettingDao(int initialCapacity) {
        super(initialCapacity);
    }

    public DefaultTransientSettingDao(Map<? extends String, ? extends ConcurrentMap<String, Object>> m) {
        super(m);
    }

    public DefaultTransientSettingDao(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public DefaultTransientSettingDao(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public <V> ConcurrentMap<String, V> settings(String key) {
        ConcurrentMap result = this.computeIfAbsent(key, k -> new ConcurrentHashMap(this.settingsInitialCapacity, this.settingsLoadFactor, this.settingsConcurrencyLevel));
        return result;
    }

    public int getSettingsInitialCapacity() {
        return this.settingsInitialCapacity;
    }

    public void setSettingsInitialCapacity(int settingsInitialCapacity) {
        this.settingsInitialCapacity = settingsInitialCapacity;
    }

    public float getSettingsLoadFactor() {
        return this.settingsLoadFactor;
    }

    public void setSettingsLoadFactor(float settingsLoadFactor) {
        this.settingsLoadFactor = settingsLoadFactor;
    }

    public int getSettingsConcurrencyLevel() {
        return this.settingsConcurrencyLevel;
    }

    public void setSettingsConcurrencyLevel(int settingsConcurrencyLevel) {
        this.settingsConcurrencyLevel = settingsConcurrencyLevel;
    }
}

