/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.dao;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.node.dao.DatumDao;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.service.DatumFilterService;
import net.solarnetwork.service.OptionalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringDatumDao
implements DatumDao {
    private final OptionalService<DatumDao> delegate;
    private final OptionalService<DatumFilterService> filterService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public FilteringDatumDao(OptionalService<DatumDao> delegate, OptionalService<DatumFilterService> filterService) {
        this.delegate = delegate;
        this.filterService = filterService;
    }

    @Override
    public void storeDatum(NodeDatum datum) {
        DatumFilterService filter = (DatumFilterService)OptionalService.service(this.filterService);
        DatumDao dao = (DatumDao)OptionalService.service(this.delegate);
        if (datum != null && filter != null && datum.asSampleOperations() != null) {
            DatumSamplesOperations samples = filter.filter((Datum)datum, datum.asSampleOperations(), null);
            if (samples == null || samples.isEmpty()) {
                this.log.debug("Datum filter service filtered out datum {} @ {}; will not persist", (Object)datum.getSourceId(), (Object)datum.getTimestamp());
                return;
            }
            if (samples.differsFrom(datum.asSampleOperations())) {
                this.log.debug("Samples transform service modified datum {} @ {} properties to {}", new Object[]{datum.getSourceId(), datum.getTimestamp(), samples});
                NodeDatum copy = datum.copyWithSamples(samples);
                dao.storeDatum(copy);
                return;
            }
        }
        dao.storeDatum(datum);
    }

    @Override
    public List<NodeDatum> getDatumNotUploaded(String destination) {
        DatumDao dao = (DatumDao)OptionalService.service(this.delegate);
        return dao != null ? dao.getDatumNotUploaded(destination) : Collections.emptyList();
    }

    @Override
    public void setDatumUploaded(NodeDatum datum, Instant date, String destination, String trackingId) {
        DatumDao dao = (DatumDao)OptionalService.service(this.delegate);
        if (dao != null) {
            dao.setDatumUploaded(datum, date, destination, trackingId);
        }
    }

    @Override
    public int deleteUploadedDataOlderThan(int hours) {
        DatumDao dao = (DatumDao)OptionalService.service(this.delegate);
        return dao != null ? dao.deleteUploadedDataOlderThan(hours) : 0;
    }
}

