/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.solarnetwork.node.domain.SecurityActor;
import net.solarnetwork.node.domain.SecurityToken;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class AuthenticatedToken
extends User
implements SecurityActor {
    private static final long serialVersionUID = -3282529010625928648L;
    private final SecurityToken token;

    public AuthenticatedToken(SecurityToken token, String ... roles) {
        super((String)((Object)((SecurityToken)((Object)ObjectUtils.requireNonNullArgument((Object)((Object)token), (String)"token"))).getId()), "", true, true, true, true, AuthenticatedToken.roles(roles));
        this.token = token;
    }

    public AuthenticatedToken(SecurityToken token, Collection<? extends GrantedAuthority> authorities) {
        super((String)((Object)((SecurityToken)((Object)ObjectUtils.requireNonNullArgument((Object)((Object)token), (String)"token"))).getId()), "", true, true, true, true, (Collection)ObjectUtils.requireNonNullArgument(authorities, (String)"authorities"));
        this.token = token;
    }

    private static List<GrantedAuthority> roles(String ... roles) {
        ObjectUtils.requireNonEmptyArgument((Object[])roles, (String)"roles");
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(roles.length);
        for (String role : roles) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_" + role));
        }
        return authorities;
    }

    @Override
    public boolean isAuthenticatedWithToken() {
        return true;
    }

    @Override
    public SecurityToken getSecurityToken() {
        return this.token;
    }
}

