/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import net.solarnetwork.domain.BasicDeviceInfo;
import net.solarnetwork.domain.DeviceInfo;

public interface DataAccessor {
    public static final String INFO_KEY_DEVICE_NAME = "Name";
    public static final String INFO_KEY_DEVICE_MODEL = "Model";
    public static final String INFO_KEY_DEVICE_SERIAL_NUMBER = "Serial Number";
    public static final String INFO_KEY_DEVICE_MANUFACTURER = "Manufacturer";
    public static final String INFO_KEY_DEVICE_MANUFACTURE_DATE = "Manufacture Date";
    public static final String INFO_KEY_DEVICE_VERSION = "Version";

    public Instant getDataTimestamp();

    public Map<String, Object> getDeviceInfo();

    default public DeviceInfo deviceInfo() {
        BasicDeviceInfo.Builder b = this.deviceInfoBuilder();
        return b.isEmpty() ? null : b.build();
    }

    default public BasicDeviceInfo.Builder deviceInfoBuilder() {
        Map<String, Object> info = this.getDeviceInfo();
        return DataAccessor.deviceInfoBuilderForInfo(info);
    }

    public static BasicDeviceInfo.Builder deviceInfoBuilderForInfo(Map<String, ?> info) {
        BasicDeviceInfo.Builder b = BasicDeviceInfo.builder();
        if (info != null && !info.isEmpty()) {
            Object o = info.get(INFO_KEY_DEVICE_NAME);
            if (o != null) {
                b.withName(o.toString());
            }
            if ((o = info.get(INFO_KEY_DEVICE_MANUFACTURER)) != null) {
                b.withManufacturer(o.toString());
            }
            if ((o = info.get(INFO_KEY_DEVICE_MODEL)) != null) {
                b.withModelName(o.toString());
            }
            if ((o = info.get(INFO_KEY_DEVICE_SERIAL_NUMBER)) != null) {
                b.withSerialNumber(o.toString());
            }
            if ((o = info.get(INFO_KEY_DEVICE_VERSION)) != null) {
                b.withVersion(o.toString());
            }
            if ((o = info.get(INFO_KEY_DEVICE_MANUFACTURE_DATE)) instanceof TemporalAccessor) {
                TemporalAccessor p = (TemporalAccessor)o;
                try {
                    b.withManufactureDate(LocalDate.of(p.get(ChronoField.YEAR), p.get(ChronoField.MONTH_OF_YEAR), p.get(ChronoField.DAY_OF_MONTH)));
                }
                catch (DateTimeException dateTimeException) {
                    // empty catch block
                }
            }
        }
        return b;
    }
}

