/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumExpressionRoot;
import net.solarnetwork.domain.datum.DatumMetadataOperations;
import net.solarnetwork.domain.datum.DatumSamplesExpressionRoot;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.service.DatumService;
import net.solarnetwork.node.service.OperationalModesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionRoot
extends DatumSamplesExpressionRoot {
    private static final Logger log = LoggerFactory.getLogger(ExpressionRoot.class);
    private final DatumService datumService;
    private final OperationalModesService opModesService;

    public ExpressionRoot(Datum datum) {
        this(datum, null, null, null);
    }

    public ExpressionRoot(Datum datum, DatumSamplesOperations samples) {
        this(datum, samples, null, null);
    }

    public ExpressionRoot(Map<String, ?> data, Datum datum) {
        this(datum, null, data, null);
    }

    public ExpressionRoot(Datum datum, DatumSamplesOperations samples, Map<String, ?> parameters, DatumService datumService) {
        this(datum, samples, parameters, datumService, null);
    }

    public ExpressionRoot(Datum datum, DatumSamplesOperations samples, Map<String, ?> parameters, DatumService datumService, OperationalModesService opModesService) {
        super(datum, samples, parameters);
        this.datumService = datumService;
        this.opModesService = opModesService;
    }

    public String toString() {
        String data = super.toString();
        if (log.isTraceEnabled()) {
            if (this.datumService != null) {
                try {
                    Collection<NodeDatum> latestDatum = this.datumService.latest(Collections.emptySet(), NodeDatum.class);
                    if (latestDatum != null && !latestDatum.isEmpty()) {
                        for (NodeDatum d : latestDatum) {
                            data = data + "\nDatum [" + d.getSourceId() + "]: " + d;
                        }
                        for (NodeDatum d : latestDatum) {
                            try {
                                DatumMetadataOperations meta = this.datumService.datumMetadata(d.getSourceId());
                                if (meta == null || meta.isEmpty()) continue;
                                data = data + "\nMeta [" + d.getSourceId() + "]: " + meta;
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception latestDatum) {
                    // empty catch block
                }
            }
            if (this.opModesService != null) {
                try {
                    Set<String> activeModes = this.opModesService.activeOperationalModes();
                    if (activeModes != null && !activeModes.isEmpty()) {
                        data = data + "\nActive op modes: " + activeModes;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return data;
    }

    public boolean hasLatest(String sourceId) {
        return this.hasOffset(sourceId, 0);
    }

    public DatumExpressionRoot latest(String sourceId) {
        return this.offset(sourceId, 0);
    }

    public boolean hasLatestMatching(String sourceIdPattern) {
        return this.latestMatching(sourceIdPattern) != null;
    }

    public Collection<DatumExpressionRoot> latestMatching(String sourceIdPattern) {
        if (this.datumService == null || sourceIdPattern == null) {
            return Collections.emptyList();
        }
        Set<String> pats = Collections.singleton(sourceIdPattern);
        Collection<NodeDatum> found = this.datumService.offset(pats, this.getTimestamp(), 0, NodeDatum.class);
        if (found == null || found.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DatumExpressionRoot> result = new ArrayList<DatumExpressionRoot>(found.size());
        for (Datum datum : found) {
            result.add((DatumExpressionRoot)new ExpressionRoot(datum, null, null, this.datumService, this.opModesService));
        }
        return result;
    }

    public boolean hasLatestOthersMatching(String sourceIdPattern) {
        return this.latestOthersMatching(sourceIdPattern) != null;
    }

    public Collection<DatumExpressionRoot> latestOthersMatching(String sourceIdPattern) {
        if (this.datumService == null || sourceIdPattern == null) {
            return Collections.emptyList();
        }
        Set<String> pats = Collections.singleton(sourceIdPattern);
        Collection<NodeDatum> found = this.datumService.offset(pats, this.getTimestamp(), 0, NodeDatum.class);
        if (found == null || found.isEmpty()) {
            return Collections.emptyList();
        }
        String sourceId = this.getSourceId();
        ArrayList<DatumExpressionRoot> result = new ArrayList<DatumExpressionRoot>(found.size());
        for (Datum datum : found) {
            if (sourceId != null && sourceId.equals(datum.getSourceId())) continue;
            result.add((DatumExpressionRoot)new ExpressionRoot(datum, null, null, this.datumService, this.opModesService));
        }
        return result;
    }

    public Collection<DatumExpressionRoot> selfAndLatestMatching(String sourceIdPattern) {
        if (this.datumService == null || sourceIdPattern == null) {
            return Collections.emptyList();
        }
        Set<String> pats = Collections.singleton(sourceIdPattern);
        Collection<NodeDatum> found = this.datumService.offset(pats, this.getTimestamp(), 0, NodeDatum.class);
        if (found == null || found.isEmpty()) {
            return Collections.singleton(this);
        }
        String sourceId = this.getSourceId();
        ArrayList<DatumExpressionRoot> result = new ArrayList<DatumExpressionRoot>(found.size());
        result.add((DatumExpressionRoot)this);
        for (Datum datum : found) {
            if (sourceId != null && sourceId.equals(datum.getSourceId())) continue;
            result.add((DatumExpressionRoot)new ExpressionRoot(datum, null, null, this.datumService, this.opModesService));
        }
        return result;
    }

    public String getSourceId() {
        Datum datum = this.getDatum();
        return datum != null ? datum.getSourceId() : null;
    }

    public Instant getTimestamp() {
        Datum datum = this.getDatum();
        return datum != null ? datum.getTimestamp() : null;
    }

    public boolean hasOffset(int offset) {
        if (offset == 0) {
            return true;
        }
        Datum datum = this.getDatum();
        if (datum == null) {
            return false;
        }
        return this.hasOffset(datum.getSourceId(), datum.getTimestamp(), offset);
    }

    public DatumExpressionRoot offset(int offset) {
        Datum datum = this.getDatum();
        if (datum == null) {
            return null;
        }
        if (offset == 0) {
            return this;
        }
        return this.offset(datum.getSourceId(), datum.getTimestamp(), offset);
    }

    public boolean hasOffset(String sourceId, int offset) {
        if (this.datumService == null || sourceId == null) {
            return false;
        }
        NodeDatum d = this.datumService.offset(sourceId, offset, NodeDatum.class);
        return d != null;
    }

    public DatumExpressionRoot offset(String sourceId, int offset) {
        if (this.datumService == null || sourceId == null) {
            return null;
        }
        NodeDatum d = this.datumService.offset(sourceId, offset, NodeDatum.class);
        if (d == null) {
            return null;
        }
        return new ExpressionRoot(d, null, null, this.datumService, this.opModesService);
    }

    public boolean hasOffset(String sourceId, Instant timestamp, int offset) {
        if (this.datumService == null || sourceId == null || timestamp == null) {
            return false;
        }
        NodeDatum d = this.datumService.offset(sourceId, timestamp, offset, NodeDatum.class);
        return d != null;
    }

    public DatumExpressionRoot offset(String sourceId, Instant timestamp, int offset) {
        if (this.datumService == null || sourceId == null || timestamp == null) {
            return null;
        }
        NodeDatum d = this.datumService.offset(sourceId, timestamp, offset, NodeDatum.class);
        if (d == null) {
            return null;
        }
        return new ExpressionRoot(d, null, null, this.datumService, this.opModesService);
    }

    public Collection<DatumExpressionRoot> slice(String sourceId, int offset, int count) {
        if (this.datumService == null || sourceId == null) {
            return Collections.emptyList();
        }
        Collection found = this.datumService.slice(sourceId, offset, count, null);
        if (found == null || found.isEmpty()) {
            return Collections.singleton(this);
        }
        ArrayList<DatumExpressionRoot> result = new ArrayList<DatumExpressionRoot>(found.size());
        result.add((DatumExpressionRoot)this);
        for (NodeDatum d : found) {
            result.add((DatumExpressionRoot)new ExpressionRoot(d, null, null, this.datumService, this.opModesService));
        }
        return result;
    }

    public Collection<DatumExpressionRoot> slice(String sourceId, Instant timestamp, int offset, int count) {
        if (this.datumService == null || sourceId == null) {
            return Collections.emptyList();
        }
        Collection found = this.datumService.slice(sourceId, offset, count, null);
        if (found == null || found.isEmpty()) {
            return Collections.singleton(this);
        }
        ArrayList<DatumExpressionRoot> result = new ArrayList<DatumExpressionRoot>(found.size());
        result.add((DatumExpressionRoot)this);
        for (NodeDatum d : found) {
            result.add((DatumExpressionRoot)new ExpressionRoot(d, null, null, this.datumService, this.opModesService));
        }
        return result;
    }

    public boolean isOpMode(String mode) {
        if (this.opModesService == null) {
            return false;
        }
        return this.opModesService.isOperationalModeActive(mode);
    }

    public boolean hasMeta() {
        return this.hasMeta(this.getSourceId());
    }

    public DatumMetadataOperations getMeta() {
        return this.meta(this.getSourceId());
    }

    public boolean hasMeta(String sourceId) {
        return this.meta(sourceId) != null;
    }

    public DatumMetadataOperations meta(String sourceId) {
        return this.datumService != null && sourceId != null ? this.datumService.datumMetadata(sourceId) : null;
    }

    public Collection<DatumMetadataOperations> metaMatching(String sourceIdFilter) {
        return this.datumService != null ? this.datumService.datumMetadata(Collections.singleton(sourceIdFilter)) : Collections.emptyList();
    }
}

