/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain;

import net.solarnetwork.node.domain.SecurityToken;
import net.solarnetwork.security.SecurityException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public interface SecurityActor {
    public boolean isAuthenticatedWithToken();

    public SecurityToken getSecurityToken();

    public static Authentication getCurrentAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static SecurityActor getCurrentActor() throws SecurityException {
        Authentication auth = SecurityActor.getCurrentAuthentication();
        if (auth != null && auth.getPrincipal() instanceof SecurityActor) {
            return (SecurityActor)auth.getPrincipal();
        }
        if (auth != null && auth.getDetails() instanceof SecurityActor) {
            return (SecurityActor)auth.getDetails();
        }
        throw new SecurityException("Actor not available");
    }
}

