/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Instant;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Function;
import net.solarnetwork.dao.BasicStringEntity;
import net.solarnetwork.security.AbstractAuthorizationBuilder;
import net.solarnetwork.util.ObjectUtils;

@JsonIgnoreProperties(value={"createdDate"})
@JsonPropertyOrder(value={"tokenId", "created", "name", "description"})
public class SecurityToken
extends BasicStringEntity {
    private static final long serialVersionUID = -440817156290937870L;
    private final String tokenSecret;
    private final String name;
    private final String description;

    public SecurityToken(String tokenId, String tokenSecret) {
        this(tokenId, null, tokenSecret, null, null);
    }

    public SecurityToken(String tokenId, Instant created, String tokenSecret, String name, String description) {
        super((String)ObjectUtils.requireNonNullArgument((Object)tokenId, (String)"tokenId"), created);
        this.tokenSecret = (String)ObjectUtils.requireNonNullArgument((Object)tokenSecret, (String)"tokenSecret");
        this.name = name;
        this.description = description;
    }

    public static SecurityToken tokenDetails(String tokenId, String name, String description) {
        return new SecurityToken(tokenId, null, name, description);
    }

    public static SecurityToken tokenDetails(String name, String description) {
        return new SecurityToken(null, name, description);
    }

    private SecurityToken(String tokenId, Instant created, String name, String description) {
        super((String)ObjectUtils.requireNonNullArgument((Object)tokenId, (String)"tokenId"), created);
        this.tokenSecret = null;
        this.name = name;
        this.description = description;
    }

    private SecurityToken(String tokenId, String name, String description) {
        super(tokenId, null);
        this.tokenSecret = null;
        this.name = name;
        this.description = description;
    }

    public SecurityToken copyWithoutSecret(String newName, String newDescription) {
        return new SecurityToken((String)((Object)this.getId()), this.getCreated(), newName != null ? newName : this.name, newDescription != null ? newDescription : this.description);
    }

    public <T extends AbstractAuthorizationBuilder<T>> T saveSigningKey(AbstractAuthorizationBuilder<T> builder) {
        return (T)((AbstractAuthorizationBuilder)ObjectUtils.requireNonNullArgument(builder, (String)"builder")).saveSigningKey(this.tokenSecret);
    }

    public void copySecret(Consumer<String> dest) {
        dest.accept(this.tokenSecret);
    }

    public <T> T applySecret(Function<String, T> dest) {
        return dest.apply(this.tokenSecret);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SecurityToken{");
        builder.append("id=");
        builder.append((String)((Object)this.getId()));
        if (this.name != null) {
            builder.append(", name=");
            builder.append(this.name);
        }
        builder.append("}");
        return builder.toString();
    }

    public Date getCreatedDate() {
        Instant ts = this.getCreated();
        return ts != null ? Date.from(ts) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

