/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.domain.datum;

import java.math.BigDecimal;
import java.time.Instant;
import net.solarnetwork.domain.NodeControlInfo;
import net.solarnetwork.domain.NodeControlPropertyType;
import net.solarnetwork.domain.datum.DatumId;
import net.solarnetwork.domain.datum.DatumSamples;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.MutableDatumSamplesOperations;
import net.solarnetwork.node.domain.datum.SimpleDatum;

public class SimpleNodeControlInfoDatum
extends SimpleDatum
implements NodeControlInfo {
    private static final long serialVersionUID = -8695996894629256515L;
    public static final String DEFAULT_PROPERTY_NAME = "val";
    public static final String DEFAULT_INSTANT_PROPERTY_NAME = "v";
    private static final String[] DATUM_TYPES = new String[]{NodeControlInfo.class.getName()};
    private final NodeControlInfo info;

    public SimpleNodeControlInfoDatum(NodeControlInfo info, Instant timestamp) {
        super(DatumId.nodeId(null, (String)info.getControlId(), (Instant)timestamp), new DatumSamples());
        this.info = info;
        this.populateInfo(info);
    }

    public SimpleNodeControlInfoDatum(NodeControlInfo info, Instant timestamp, Iterable<NodeControlInfo> infos) {
        this(info, timestamp);
        for (NodeControlInfo n : infos) {
            this.populateInfo(n);
        }
    }

    @Override
    public SimpleNodeControlInfoDatum clone() {
        return (SimpleNodeControlInfoDatum)super.clone();
    }

    private void populateInfo(NodeControlInfo controlInfo) {
        String propertyName = DEFAULT_PROPERTY_NAME;
        if (controlInfo.getPropertyName() != null && controlInfo.getPropertyName().length() > 0) {
            propertyName = controlInfo.getPropertyName();
        }
        String value = controlInfo.getValue();
        MutableDatumSamplesOperations ops = this.asMutableSampleOperations();
        switch (controlInfo.getType()) {
            case Boolean: {
                if (value.length() > 0 && (value.equals("1") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true"))) {
                    ops.putSampleValue(DatumSamplesType.Status, propertyName, (Object)1);
                    break;
                }
                ops.putSampleValue(DatumSamplesType.Status, propertyName, (Object)0);
                break;
            }
            case Integer: {
                Integer val = Integer.valueOf(value);
                ops.putSampleValue(DatumSamplesType.Status, propertyName, (Object)val);
                if (!propertyName.equals(DEFAULT_PROPERTY_NAME)) break;
                ops.putSampleValue(DatumSamplesType.Instantaneous, DEFAULT_INSTANT_PROPERTY_NAME, (Object)val);
                break;
            }
            case Float: 
            case Percent: {
                BigDecimal decimalValue = new BigDecimal(value);
                ops.putSampleValue(DatumSamplesType.Status, propertyName, (Object)decimalValue);
                if (!propertyName.equals(DEFAULT_PROPERTY_NAME)) break;
                ops.putSampleValue(DatumSamplesType.Instantaneous, DEFAULT_INSTANT_PROPERTY_NAME, (Object)decimalValue);
                break;
            }
            default: {
                ops.putSampleValue(DatumSamplesType.Status, propertyName, (Object)value);
            }
        }
    }

    protected String[] datumTypes() {
        return DATUM_TYPES;
    }

    public String getControlId() {
        return this.info.getControlId();
    }

    public String getPropertyName() {
        return this.info.getPropertyName();
    }

    public NodeControlPropertyType getType() {
        return this.info.getType();
    }

    public String getValue() {
        return this.info.getValue();
    }

    public Boolean getReadonly() {
        return this.info.getReadonly();
    }

    public String getUnit() {
        return this.info.getUnit();
    }
}

