/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.job;

import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class JobUtils {
    public static final Pattern CRON_PLAIN_SECOND_FIELD_PATTERN = Pattern.compile("^\\s*\\d+(?=\\s+)");
    private static final Logger log = LoggerFactory.getLogger(JobUtils.class);

    private JobUtils() {
    }

    public static Trigger triggerForExpression(String expression, TimeUnit timeUnit, boolean randomized) {
        if (expression != null) {
            try {
                try {
                    long frequency = Long.parseLong(expression);
                    PeriodicTrigger trigger = new PeriodicTrigger(frequency, timeUnit);
                    trigger.setFixedRate(true);
                    return trigger;
                }
                catch (NumberFormatException frequency) {
                    Matcher m;
                    String cronExpr = expression;
                    if (randomized && (m = CRON_PLAIN_SECOND_FIELD_PATTERN.matcher(expression)).find()) {
                        int randSec = new SecureRandom().nextInt(60);
                        cronExpr = String.valueOf(randSec) + expression.substring(m.end());
                    }
                    return new CronTrigger(cronExpr);
                }
            }
            catch (IllegalArgumentException e) {
                log.warn("Error parsing cron expression [{}]: {}", (Object)expression, (Object)e.getMessage());
            }
        }
        return null;
    }
}

