/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.job;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.solarnetwork.node.job.JobService;
import net.solarnetwork.node.job.ManagedJob;
import net.solarnetwork.node.job.ServiceProvider;
import net.solarnetwork.node.job.SimpleServiceProviderConfiguration;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.settings.GroupSettingSpecifier;
import net.solarnetwork.settings.KeyedSettingSpecifier;
import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingsChangeObserver;
import net.solarnetwork.settings.support.BasicCronExpressionSettingSpecifier;
import net.solarnetwork.support.PrefixedMessageSource;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.MessageSource;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class SimpleManagedJob
extends BaseIdentifiable
implements ManagedJob,
SettingsChangeObserver,
ServiceLifecycleObserver {
    public static final String DEFAULT_SCHEDULE_SETTING_KEY = "schedule";
    private static final String JOB_SERVICE_SETTING_PREFIX = "jobService.";
    private static final String DEFAULT_VALUE_PROPERTY = "defaultValue";
    private static final Logger log = LoggerFactory.getLogger(SimpleManagedJob.class);
    private final JobService jobService;
    private String scheduleSettingKey = "schedule";
    private String schedule;
    private Map<String, SimpleServiceProviderConfiguration> serviceProviderConfigurations;
    private MessageSource messageSource;
    private PropertyAccessor jobServiceAccessor;
    private boolean ignoreLegacySchedule = false;

    public SimpleManagedJob(JobService jobService) {
        this(jobService, null);
    }

    public SimpleManagedJob(JobService jobService, String schedule) {
        this.jobService = (JobService)ObjectUtils.requireNonNullArgument((Object)jobService, (String)"jobService");
        this.schedule = schedule;
        this.setUid(UUID.randomUUID().toString());
    }

    @Override
    public JobService getJobService() {
        return this.jobService;
    }

    public String toString() {
        return String.format("SimpleManagedJob{%s @ %s}", this.jobName(), this.getSchedule());
    }

    public Trigger getTrigger() {
        String expression = this.getSchedule();
        if (expression != null) {
            try {
                try {
                    long ms = Long.parseLong(expression);
                    return new PeriodicTrigger(ms);
                }
                catch (NumberFormatException ms) {
                    return new CronTrigger(expression);
                }
            }
            catch (IllegalArgumentException e) {
                log.warn("Error parsing cron expression [{}]: {}", (Object)expression, (Object)e.getMessage());
            }
        }
        return null;
    }

    public String getSettingUid() {
        return this.jobService.getSettingUid();
    }

    public String getDisplayName() {
        String name = this.jobService.getDisplayName();
        return name != null && !name.isEmpty() ? name : super.getDisplayName();
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>();
        result.add((SettingSpecifier)new BasicCronExpressionSettingSpecifier(this.getScheduleSettingKey(), this.getSchedule()));
        for (SettingSpecifier spec : this.jobService.getSettingSpecifiers()) {
            if (spec instanceof MappableSpecifier) {
                MappableSpecifier keyedSpec = (MappableSpecifier)spec;
                SettingSpecifier mappedSpec = keyedSpec.mappedTo(JOB_SERVICE_SETTING_PREFIX);
                if (this.jobServiceAccessor != null) {
                    if (keyedSpec instanceof KeyedSettingSpecifier) {
                        this.populateLegacySettingDefaultValue(((KeyedSettingSpecifier)keyedSpec).getKey(), (KeyedSettingSpecifier)mappedSpec);
                    } else if (mappedSpec instanceof GroupSettingSpecifier) {
                        this.handleLegacyGroupSettingSpecifier((GroupSettingSpecifier)mappedSpec);
                    }
                }
                result.add(mappedSpec);
                continue;
            }
            result.add(spec);
        }
        return result;
    }

    private void handleLegacyGroupSettingSpecifier(GroupSettingSpecifier group) {
        for (SettingSpecifier spec : group.getGroupSettings()) {
            GroupSettingSpecifier child;
            if (spec instanceof GroupSettingSpecifier) {
                child = (GroupSettingSpecifier)spec;
                this.handleLegacyGroupSettingSpecifier(child);
                continue;
            }
            if (!(spec instanceof KeyedSettingSpecifier)) continue;
            child = (KeyedSettingSpecifier)spec;
            String propKey = child.getKey();
            if (propKey.startsWith(JOB_SERVICE_SETTING_PREFIX)) {
                propKey = propKey.substring(JOB_SERVICE_SETTING_PREFIX.length());
            }
            this.populateLegacySettingDefaultValue(propKey, (KeyedSettingSpecifier<?>)child);
        }
    }

    private void populateLegacySettingDefaultValue(String propKey, KeyedSettingSpecifier<?> spec) {
        BeanWrapper specAccessor = PropertyAccessorFactory.forBeanPropertyAccess(spec);
        if (specAccessor.isWritableProperty(DEFAULT_VALUE_PROPERTY)) {
            if (this.jobServiceAccessor.isReadableProperty(propKey)) {
                try {
                    Object newDefaultValue = this.jobServiceAccessor.getPropertyValue(propKey);
                    specAccessor.setPropertyValue(DEFAULT_VALUE_PROPERTY, newDefaultValue);
                }
                catch (Exception exception) {}
            } else {
                log.warn("Unable to map [{}] legacy setting property [{}] default value: property not readable", (Object)this.getSettingUid(), (Object)propKey);
            }
        }
    }

    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            PrefixedMessageSource pSource = new PrefixedMessageSource();
            pSource.setPrefix(JOB_SERVICE_SETTING_PREFIX);
            pSource.setDelegate(this.jobService.getMessageSource());
            this.messageSource = pSource;
        }
        return this.messageSource;
    }

    public void configurationChanged(Map<String, Object> properties) {
        Object scheduleVal;
        Object object = scheduleVal = properties != null ? properties.get(this.getScheduleSettingKey()) : null;
        if (scheduleVal != null) {
            String newSchedule = scheduleVal.toString();
            this.setSchedule(newSchedule);
        }
        if (this.jobService instanceof SettingsChangeObserver) {
            ((SettingsChangeObserver)this.jobService).configurationChanged(properties);
        }
    }

    public void serviceDidStartup() {
        if (this.jobService instanceof ServiceLifecycleObserver) {
            ServiceLifecycleObserver delegate = (ServiceLifecycleObserver)this.jobService;
            try {
                delegate.serviceDidStartup();
            }
            catch (Exception e) {
                log.error("Error delegating job {} lifecycle startup: {}", new Object[]{this.jobName(), e.toString(), e});
            }
        }
    }

    public void serviceDidShutdown() {
        if (this.jobService instanceof ServiceLifecycleObserver) {
            ServiceLifecycleObserver delegate = (ServiceLifecycleObserver)this.jobService;
            try {
                delegate.serviceDidShutdown();
            }
            catch (Exception e) {
                log.error("Error delegating job {} lifecycle shutdown: {}", new Object[]{this.jobName(), e.toString(), e});
            }
        }
    }

    @Override
    public Collection<ServiceProvider.ServiceConfiguration> getServiceConfigurations() {
        ArrayList<SimpleServiceProviderConfiguration> result = null;
        if (this.serviceProviderConfigurations != null && this.serviceProviderConfigurations.size() > 0) {
            BeanWrapper bean = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.jobService);
            for (Map.Entry<String, SimpleServiceProviderConfiguration> me : this.serviceProviderConfigurations.entrySet()) {
                try {
                    Object o = bean.getPropertyValue(me.getKey());
                    if (o == null) continue;
                    SimpleServiceProviderConfiguration conf = me.getValue();
                    SimpleServiceProviderConfiguration ser = new SimpleServiceProviderConfiguration();
                    ser.setService(o);
                    ser.setInterfaces(conf.getInterfaces());
                    ser.setProperties(conf.getProperties());
                    if (result == null) {
                        result = new ArrayList<SimpleServiceProviderConfiguration>();
                    }
                    result.add(ser);
                }
                catch (InvalidPropertyException | PropertyAccessException e) {
                    log.error("Error configuring job {} service provider {}: {}", new Object[]{this.jobName(), me.getKey(), e.toString()});
                }
            }
        }
        return result;
    }

    public void setServiceProviderConfigurations(Map<String, SimpleServiceProviderConfiguration> serviceProviderConfigurations) {
        this.serviceProviderConfigurations = serviceProviderConfigurations;
    }

    private String jobName() {
        String name = this.getDisplayName();
        if (name == null || name.isEmpty()) {
            name = String.format("%s job", this.jobService.getClass().getSimpleName());
        }
        return name;
    }

    public SimpleManagedJob getJobDetail() {
        return this;
    }

    public synchronized Map<String, Object> getJobDataMap() {
        if (this.jobServiceAccessor == null) {
            this.jobServiceAccessor = PropertyAccessorFactory.forBeanPropertyAccess((Object)this.jobService);
        }
        return new AbstractMap<String, Object>(){

            @Override
            public Object get(Object key) {
                if (key == null) {
                    return null;
                }
                if (SimpleManagedJob.this.jobServiceAccessor.isReadableProperty(key.toString())) {
                    return SimpleManagedJob.this.jobServiceAccessor.getPropertyValue(key.toString());
                }
                return null;
            }

            @Override
            public Object put(String key, Object value) {
                if (key == null) {
                    return null;
                }
                Object result = null;
                if (SimpleManagedJob.this.jobServiceAccessor.isWritableProperty(key)) {
                    if (SimpleManagedJob.this.jobServiceAccessor.isReadableProperty(key)) {
                        result = SimpleManagedJob.this.jobServiceAccessor.getPropertyValue(key);
                    }
                    SimpleManagedJob.this.jobServiceAccessor.setPropertyValue(key, value);
                }
                return result;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                return Collections.emptySet();
            }
        };
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.ignoreLegacySchedule = true;
        this.schedule = schedule;
    }

    public void setTriggerCronExpression(String schedule) {
        if (!this.ignoreLegacySchedule) {
            this.schedule = schedule;
        }
    }

    @Override
    public String getScheduleSettingKey() {
        return this.scheduleSettingKey;
    }

    public void setScheduleSettingKey(String scheduleSettingKey) {
        this.scheduleSettingKey = scheduleSettingKey;
    }
}

