/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.reactor;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.solarnetwork.node.reactor.InstructionStatus;

public interface Instruction
extends net.solarnetwork.domain.Instruction {
    public static final String LOCAL_INSTRUCTION_ID = "LOCAL";
    public static final String PARAM_EXECUTION_DATE = "executionDate";
    public static final String PARAM_PARENT_INSTRUCTION_ID = "parentInstructionId";
    public static final String PARAM_PARENT_INSTRUCTOR_ID = "parentInstructorId";

    default public String getIdentifier() {
        Long id = this.getId();
        return id != null ? id.toString() : LOCAL_INSTRUCTION_ID;
    }

    public String getInstructorId();

    public InstructionStatus getStatus();

    default public Instant getExecutionDate() {
        return this.timestampParameterValue(PARAM_EXECUTION_DATE);
    }

    default public Instant timestampParameterValue(String parameterName) {
        if (parameterName == null) {
            return null;
        }
        String val = this.getParameterValue(parameterName);
        if (val == null) {
            return null;
        }
        Instant result = null;
        try {
            result = Instant.ofEpochMilli(Long.parseLong(val));
        }
        catch (NumberFormatException | DateTimeException e) {
            try {
                result = DateTimeFormatter.ISO_INSTANT.parse((CharSequence)val, Instant::from);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return result;
    }

    default public boolean isLocal() {
        return LOCAL_INSTRUCTION_ID.equals(this.getInstructorId());
    }
}

