/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.util.CircularFifoQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatumHistory {
    public static final Configuration DEFAULT_CONFIG = new Configuration(5);
    private static final Logger log = LoggerFactory.getLogger(DatumHistory.class);
    private final Configuration config;
    private final ConcurrentMap<String, Queue<NodeDatum>> raw;

    public DatumHistory(Configuration config) {
        this(config, 0.75f, 4);
    }

    public DatumHistory(Configuration config, float loadFactor, int concurrencyLevel) {
        this(config, new ConcurrentHashMap<String, Queue<NodeDatum>>(8, loadFactor, concurrencyLevel));
    }

    public DatumHistory(Configuration config, ConcurrentMap<String, Queue<NodeDatum>> raw) {
        if (config == null) {
            throw new IllegalArgumentException("The config argument must not be null.");
        }
        this.config = config;
        this.raw = raw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NodeDatum datum) {
        Queue q;
        log.debug("Adding datum: {}", (Object)datum);
        if (datum == null || datum.getSourceId() == null || datum.getTimestamp() == null) {
            return;
        }
        Queue queue = q = this.raw.computeIfAbsent(datum.getSourceId(), k -> new CircularFifoQueue(this.config.rawCount));
        synchronized (queue) {
            q.add(datum);
        }
    }

    public Iterable<NodeDatum> latest() {
        return this.offset(0);
    }

    public NodeDatum latest(String sourceId) {
        return this.offset(sourceId, 0);
    }

    public Iterable<NodeDatum> offset(final int offset) {
        return new Iterable<NodeDatum>(){

            @Override
            public Iterator<NodeDatum> iterator() {
                ArrayList<NodeDatum> datum = new ArrayList<NodeDatum>(DatumHistory.this.raw.size());
                for (String sourceId : DatumHistory.this.raw.keySet()) {
                    NodeDatum d = DatumHistory.this.offset(sourceId, offset);
                    if (d == null) continue;
                    datum.add(d);
                }
                return datum.iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDatum offset(String sourceId, int offset) {
        NodeDatum result;
        Queue q = (Queue)this.raw.get(sourceId);
        log.debug("Queue [{}] @ {} : {}", new Object[]{sourceId, offset, q});
        if (q == null) {
            return null;
        }
        Queue queue = q;
        synchronized (queue) {
            int idx = q.size() - 1 - offset;
            result = idx >= 0 ? (NodeDatum)((CircularFifoQueue)q).get(idx) : null;
        }
        return result;
    }

    public Iterable<NodeDatum> offset(final Instant timestamp, final int offset) {
        return new Iterable<NodeDatum>(){

            @Override
            public Iterator<NodeDatum> iterator() {
                ArrayList<NodeDatum> datum = new ArrayList<NodeDatum>(DatumHistory.this.raw.size());
                for (String sourceId : DatumHistory.this.raw.keySet()) {
                    NodeDatum d = DatumHistory.this.offset(sourceId, timestamp, offset);
                    if (d == null) continue;
                    datum.add(d);
                }
                return datum.iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDatum offset(String sourceId, Instant timestamp, int offset) {
        Queue q = (Queue)this.raw.get(sourceId);
        log.debug("Queue [{}] @ {} @ {} : {}", new Object[]{sourceId, timestamp, offset, q});
        if (q == null) {
            return null;
        }
        NodeDatum result = null;
        Queue queue = q;
        synchronized (queue) {
            int idx = q.size();
            while (--idx >= 0) {
                NodeDatum d = (NodeDatum)((CircularFifoQueue)q).get(idx);
                if (d.getTimestamp().compareTo(timestamp) > 0) continue;
                int offsetIdx = idx - offset;
                if (offsetIdx <= 0) break;
                result = offsetIdx == idx ? d : (NodeDatum)((CircularFifoQueue)q).get(offsetIdx);
                break;
            }
        }
        return result;
    }

    public Iterable<NodeDatum> slice(String sourceId, final int offset, final int count) {
        final Queue q = (Queue)this.raw.get(sourceId);
        log.debug("Queue [{}]: {}", (Object)sourceId, (Object)q);
        if (q == null) {
            return null;
        }
        return new Iterable<NodeDatum>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<NodeDatum> iterator() {
                ArrayList<NodeDatum> datum = new ArrayList<NodeDatum>(count);
                Queue queue = q;
                synchronized (queue) {
                    int size = q.size();
                    int max = size - offset;
                    for (int idx = Math.max(max - count, 0); idx < max; ++idx) {
                        NodeDatum d = (NodeDatum)((CircularFifoQueue)q).get(idx);
                        datum.add(d);
                    }
                }
                return datum.iterator();
            }
        };
    }

    public Iterable<NodeDatum> slice(String sourceId, final Instant timestamp, final int offset, final int count) {
        final Queue q = (Queue)this.raw.get(sourceId);
        log.debug("Queue [{}]: {}", (Object)sourceId, (Object)q);
        if (q == null) {
            return null;
        }
        return new Iterable<NodeDatum>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<NodeDatum> iterator() {
                ArrayList<NodeDatum> datum = new ArrayList<NodeDatum>(count);
                Queue queue = q;
                synchronized (queue) {
                    int idx = q.size();
                    while (--idx >= 0) {
                        NodeDatum d = (NodeDatum)((CircularFifoQueue)q).get(idx);
                        if (d.getTimestamp().compareTo(timestamp) > 0) continue;
                        int max = idx - offset + 1;
                        for (idx = Math.max(max - count, 0); idx < max; ++idx) {
                            d = (NodeDatum)((CircularFifoQueue)q).get(idx);
                            datum.add(d);
                        }
                    }
                }
                return datum.iterator();
            }
        };
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static class Configuration {
        private final int rawCount;

        public Configuration(int rawCount) {
            if (rawCount < 1) {
                throw new IllegalArgumentException("The rawCount must be greater than 0.");
            }
            this.rawCount = rawCount;
        }

        public int getRawCount() {
            return this.rawCount;
        }
    }
}

