/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.domain.datum.DatumMetadataOperations;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionHandler;
import net.solarnetwork.node.reactor.InstructionStatus;
import net.solarnetwork.node.reactor.InstructionUtils;
import net.solarnetwork.node.runtime.DatumHistory;
import net.solarnetwork.node.service.DatumMetadataService;
import net.solarnetwork.node.service.DatumService;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.springframework.util.PathMatcher;

public class DefaultDatumService
implements DatumService,
EventHandler,
InstructionHandler,
Consumer<NodeDatum> {
    public static final String SETUP_SERVICE_LATEST_DATUM = "/setup/datum/latest";
    public static final int DEFAFULT_HISTORY_RAW_COUNT = 5;
    private final PathMatcher pathMatcher;
    private final ObjectMapper objectMapper;
    private final OptionalService<DatumMetadataService> datumMetadataService;
    private DatumHistory history = new DatumHistory(new DatumHistory.Configuration(5));

    public DefaultDatumService(PathMatcher pathMatcher, ObjectMapper objectMapper, OptionalService<DatumMetadataService> datumMetadataService) {
        this.pathMatcher = (PathMatcher)ObjectUtils.requireNonNullArgument((Object)pathMatcher, (String)"pathMatcher");
        this.objectMapper = (ObjectMapper)ObjectUtils.requireNonNullArgument((Object)objectMapper, (String)"objectMapper");
        this.datumMetadataService = (OptionalService)ObjectUtils.requireNonNullArgument(datumMetadataService, (String)"datumMetadataService");
    }

    @Override
    public <T extends NodeDatum> Collection<T> latest(Set<String> sourceIdFilter, Class<T> type) {
        return this.offset(sourceIdFilter, 0, type);
    }

    @Override
    public <T extends NodeDatum> T latest(String sourceId, Class<T> type) {
        return this.offset(sourceId, 0, type);
    }

    @Override
    public <T extends NodeDatum> T offset(String sourceId, int offset, Class<T> type) {
        NodeDatum result = this.history.offset(sourceId, offset);
        return (T)(result != null && type.isAssignableFrom(result.getClass()) ? result : null);
    }

    @Override
    public <T extends NodeDatum> Collection<T> offset(Set<String> sourceIdFilter, int offset, Class<T> type) {
        ArrayList<NodeDatum> result = new ArrayList<NodeDatum>();
        block0: for (NodeDatum d : this.history.offset(offset)) {
            if (!type.isAssignableFrom(d.getClass())) continue;
            if (sourceIdFilter != null && !sourceIdFilter.isEmpty()) {
                for (String filter : sourceIdFilter) {
                    if (!this.pathMatcher.match(filter, d.getSourceId())) continue;
                    result.add(d);
                    continue block0;
                }
                continue;
            }
            result.add(d);
        }
        return result;
    }

    @Override
    public <T extends NodeDatum> Collection<T> offset(Set<String> sourceIdFilter, Instant timestamp, int offset, Class<T> type) {
        ArrayList<NodeDatum> result = new ArrayList<NodeDatum>();
        block0: for (NodeDatum d : this.history.offset(timestamp, offset)) {
            if (!type.isAssignableFrom(d.getClass())) continue;
            if (sourceIdFilter != null && !sourceIdFilter.isEmpty()) {
                for (String filter : sourceIdFilter) {
                    if (!this.pathMatcher.match(filter, d.getSourceId())) continue;
                    result.add(d);
                    continue block0;
                }
                continue;
            }
            result.add(d);
        }
        return result;
    }

    @Override
    public <T extends NodeDatum> T offset(String sourceId, Instant timestamp, int offset, Class<T> type) {
        NodeDatum result = this.history.offset(sourceId, timestamp, offset);
        return (T)(result != null && type.isAssignableFrom(result.getClass()) ? result : null);
    }

    @Override
    public <T extends NodeDatum> Collection<T> slice(String sourceId, int offset, int count, Class<T> type) {
        ArrayList<NodeDatum> result = new ArrayList<NodeDatum>(this.history.getConfig().getRawCount());
        for (NodeDatum d : this.history.slice(sourceId, offset, count)) {
            if (type != null && !type.isAssignableFrom(d.getClass())) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public <T extends NodeDatum> Collection<T> slice(String sourceId, Instant timestamp, int offset, int count, Class<T> type) {
        ArrayList<NodeDatum> result = new ArrayList<NodeDatum>(this.history.getConfig().getRawCount());
        for (NodeDatum d : this.history.slice(sourceId, timestamp, offset, count)) {
            if (type != null && !type.isAssignableFrom(d.getClass())) continue;
            result.add(d);
        }
        return result;
    }

    @Override
    public void accept(NodeDatum datum) {
        this.history.add(datum);
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if (!"net/solarnetwork/node/service/DatumDataSource/DATUM_CAPTURED".equals(topic)) {
            return;
        }
        Object d = event.getProperty("_Datum");
        if (d instanceof NodeDatum) {
            this.history.add((NodeDatum)d);
        }
    }

    @Override
    public boolean handlesTopic(String topic) {
        return "SystemConfigure".equals(topic);
    }

    @Override
    public InstructionStatus processInstruction(Instruction instruction) {
        if (instruction == null || !this.handlesTopic(instruction.getTopic())) {
            return null;
        }
        String topic = instruction.getParameterValue("service");
        if (!SETUP_SERVICE_LATEST_DATUM.equals(topic)) {
            return null;
        }
        LinkedHashSet<String> sourceIdFilters = null;
        String serviceIdFilterParam = instruction.getParameterValue("arg");
        if (serviceIdFilterParam != null && !serviceIdFilterParam.isEmpty()) {
            try {
                String[] sourceIds = (String[])this.objectMapper.readValue(serviceIdFilterParam, String[].class);
                if (sourceIds != null && sourceIds.length > 0) {
                    sourceIdFilters = new LinkedHashSet<String>(Arrays.asList(sourceIds));
                }
            }
            catch (IOException e) {
                sourceIdFilters = StringUtils.commaDelimitedStringToSet((String)serviceIdFilterParam);
            }
        }
        Collection<NodeDatum> latest = this.latest(sourceIdFilters, NodeDatum.class);
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed, Instant.now(), Collections.singletonMap("result", latest));
    }

    @Override
    public DatumMetadataOperations datumMetadata(String sourceId) {
        DatumMetadataService service = (DatumMetadataService)OptionalService.service(this.datumMetadataService);
        return service != null ? service.getSourceMetadata(sourceId) : null;
    }

    @Override
    public Collection<DatumMetadataOperations> datumMetadata(Set<String> sourceIdFilter) {
        DatumMetadataService service = (DatumMetadataService)OptionalService.service(this.datumMetadataService);
        if (service == null) {
            return Collections.emptyList();
        }
        Set<String> metaSourceIds = service.availableSourceMetadataSourceIds();
        if (metaSourceIds == null || metaSourceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DatumMetadataOperations> result = new ArrayList<DatumMetadataOperations>(metaSourceIds.size());
        for (String sourceId : metaSourceIds) {
            GeneralDatumMetadata meta;
            boolean match = false;
            if (sourceIdFilter == null || sourceIdFilter.isEmpty()) {
                match = true;
            } else {
                for (String filter : sourceIdFilter) {
                    if (!this.pathMatcher.match(filter, sourceId)) continue;
                    match = true;
                    break;
                }
            }
            if (!match || (meta = service.getSourceMetadata(sourceId)) == null) continue;
            result.add((DatumMetadataOperations)meta);
        }
        return result;
    }

    public void setHistoryRawCount(int rawCount) {
        if (rawCount < 1) {
            return;
        }
        this.history = new DatumHistory(new DatumHistory.Configuration(rawCount));
    }
}

