/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.node.dao.SettingDao;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionHandler;
import net.solarnetwork.node.reactor.InstructionStatus;
import net.solarnetwork.node.reactor.InstructionUtils;
import net.solarnetwork.node.service.OperationalModesService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DefaultOperationalModesService
extends BaseIdentifiable
implements OperationalModesService,
InstructionHandler,
SettingSpecifierProvider,
ServiceLifecycleObserver {
    public static final String SETTING_OP_MODE = "solarnode.opmode";
    public static final String SETTING_OP_MODE_EXPIRE = "solarnode.opmode.expire";
    public static final long DEFAULT_STARTUP_DELAY = TimeUnit.SECONDS.toMillis(10L);
    public static final int DEFAULT_AUTO_EXPIRE_MODES_FREQUENCY = 20;
    public static final Long NO_EXPIRATION = -1L;
    private static final TransactionDefinition TX_RW;
    private final ConcurrentMap<String, Long> activeModes;
    private final ConcurrentMap<UUID, OperationalModesService.OperationalModeInfo> registeredModes;
    private final OptionalService<SettingDao> settingDao;
    private final OptionalService<EventAdmin> eventAdmin;
    private long startupDelay = DEFAULT_STARTUP_DELAY;
    private TaskScheduler taskScheduler;
    private OptionalService<PlatformTransactionManager> transactionManager;
    private int autoExpireModesFrequency = 20;
    private ScheduledFuture<?> startupScheduledFuture;
    private ScheduledFuture<?> autoExpireScheduledFuture;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public DefaultOperationalModesService(OptionalService<SettingDao> settingDao, OptionalService<EventAdmin> eventAdmin) {
        this(new ConcurrentHashMap<String, Long>(16, 0.9f, 2), settingDao, eventAdmin);
    }

    public DefaultOperationalModesService(ConcurrentMap<String, Long> modeCache, OptionalService<SettingDao> settingDao, OptionalService<EventAdmin> eventAdmin) {
        this(modeCache, new ConcurrentHashMap<UUID, OperationalModesService.OperationalModeInfo>(8, 0.9f, 2), settingDao, eventAdmin);
    }

    public DefaultOperationalModesService(ConcurrentMap<String, Long> modeCache, ConcurrentMap<UUID, OperationalModesService.OperationalModeInfo> registeredModes, OptionalService<SettingDao> settingDao, OptionalService<EventAdmin> eventAdmin) {
        this.activeModes = (ConcurrentMap)ObjectUtils.requireNonNullArgument(modeCache, (String)"modeCache");
        this.registeredModes = (ConcurrentMap)ObjectUtils.requireNonNullArgument(registeredModes, (String)"registeredModes");
        this.settingDao = (OptionalService)ObjectUtils.requireNonNullArgument(settingDao, (String)"settingDao");
        this.eventAdmin = eventAdmin;
    }

    public synchronized void serviceDidStartup() {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (DefaultOperationalModesService.this.settingDao.service() == null) {
                    DefaultOperationalModesService defaultOperationalModesService = DefaultOperationalModesService.this;
                    synchronized (defaultOperationalModesService) {
                        DefaultOperationalModesService.this.startupScheduledFuture = DefaultOperationalModesService.this.taskScheduler.schedule((Runnable)this, new Date(System.currentTimeMillis() + DefaultOperationalModesService.this.startupDelay));
                    }
                    return;
                }
                Set modes = DefaultOperationalModesService.this.initActiveModes();
                DefaultOperationalModesService defaultOperationalModesService = DefaultOperationalModesService.this;
                synchronized (defaultOperationalModesService) {
                    if (!modes.isEmpty()) {
                        if (DefaultOperationalModesService.this.log.isInfoEnabled()) {
                            DefaultOperationalModesService.this.log.info("Initial active operational modes [{}]", (Object)StringUtils.commaDelimitedStringFromCollection((Collection)modes));
                        }
                        DefaultOperationalModesService.this.postOperationalModesChangedEvent(modes);
                    }
                    DefaultOperationalModesService.this.startupScheduledFuture = null;
                }
            }
        };
        if (this.taskScheduler != null && this.startupDelay > 0L && this.startupScheduledFuture == null) {
            this.startupScheduledFuture = this.taskScheduler.schedule(task, new Date(System.currentTimeMillis() + this.startupDelay));
        } else {
            task.run();
        }
        if (this.taskScheduler != null && this.autoExpireScheduledFuture == null) {
            this.autoExpireScheduledFuture = this.taskScheduler.scheduleWithFixedDelay((Runnable)new AutoExpireModesTask(), new Date(System.currentTimeMillis() + this.startupDelay + (long)this.autoExpireModesFrequency * 1000L), (long)this.autoExpireModesFrequency * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Set<String> initActiveModes() {
        this.activeModes.clear();
        SettingDao dao = (SettingDao)this.settingDao.service();
        if (dao == null) {
            return Collections.emptySet();
        }
        PlatformTransactionManager txManager = (PlatformTransactionManager)OptionalService.service(this.transactionManager);
        TransactionStatus tx = null;
        if (txManager != null) {
            tx = txManager.getTransaction(TX_RW);
        }
        try {
            List<KeyValuePair> modes = dao.getSettingValues(SETTING_OP_MODE);
            if (modes == null) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            LinkedHashSet<String> active = new LinkedHashSet<String>();
            long now = System.currentTimeMillis();
            for (KeyValuePair kv : modes) {
                String mode = kv.getValue();
                Long exp = this.modeExpiration(dao, mode);
                if (exp != null && exp <= now) continue;
                this.activeModes.put(mode, exp != null ? exp : NO_EXPIRATION);
                active.add(mode);
            }
            LinkedHashSet<String> linkedHashSet = active;
            return linkedHashSet;
        }
        finally {
            if (tx != null) {
                txManager.commit(tx);
            }
        }
    }

    public void expireNow() {
        new AutoExpireModesTask().run();
    }

    public synchronized void serviceDidShutdown() {
        if (this.autoExpireScheduledFuture != null) {
            this.autoExpireScheduledFuture.cancel(true);
            this.autoExpireScheduledFuture = null;
        }
        if (this.startupScheduledFuture != null) {
            this.startupScheduledFuture.cancel(true);
            this.startupScheduledFuture = null;
        }
    }

    public String getSettingUid() {
        return DefaultOperationalModesService.class.getName();
    }

    public String getDisplayName() {
        return "Operational Modes Servcie";
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        MessageSource messages = this.getMessageSource();
        StringBuilder buf = new StringBuilder();
        TreeSet modes = new TreeSet(this.activeModes.keySet());
        for (String mode : modes) {
            Long exp = (Long)this.activeModes.get(mode);
            buf.append(messages.getMessage("activeModes.row", new Object[]{mode, !NO_EXPIRATION.equals(exp) ? DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(exp), ZoneId.systemDefault())) : "-"}, null));
        }
        String status = messages.getMessage("activeModes.msg", new Object[]{buf}, null);
        return Collections.singletonList(new BasicTitleSettingSpecifier("activeModes", status, true, true));
    }

    @Override
    public boolean handlesTopic(String topic) {
        return "EnableOperationalModes".equals(topic) || "DisableOperationalModes".equals(topic);
    }

    @Override
    public InstructionStatus processInstruction(Instruction instruction) {
        if (instruction == null) {
            return null;
        }
        String topic = instruction.getTopic();
        if (!this.handlesTopic(topic)) {
            return null;
        }
        String[] modes = instruction.getAllParameterValues("OpMode");
        if (modes == null || modes.length < 1) {
            return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined);
        }
        Instant expire = OperationalModesService.expirationDate(instruction);
        LinkedHashSet<String> opModes = new LinkedHashSet<String>(Arrays.asList(modes));
        switch (topic) {
            case "EnableOperationalModes": {
                this.enableOperationalModes(opModes, expire);
                break;
            }
            case "DisableOperationalModes": {
                this.disableOperationalModes(opModes);
            }
        }
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed);
    }

    @Override
    public boolean isOperationalModeActive(String mode) {
        Long exp;
        boolean result;
        if (mode == null || mode.isEmpty()) {
            return true;
        }
        boolean inverted = false;
        if ((mode = mode.toLowerCase()).charAt(0) == '!') {
            if ((mode = mode.substring(1)).isEmpty()) {
                return this.activeModes.isEmpty();
            }
            inverted = true;
        }
        boolean bl = result = (exp = (Long)this.activeModes.get(mode)) != null && (NO_EXPIRATION.equals(exp) || exp > System.currentTimeMillis());
        return inverted ? !result : result;
    }

    @Override
    public Set<String> activeOperationalModes() {
        long now = System.currentTimeMillis();
        return this.activeModes.entrySet().stream().filter(e -> {
            Long exp = (Long)e.getValue();
            return NO_EXPIRATION.equals(exp) || exp > now;
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Map<String, Long> activeOperationalModesWithExpirations() {
        long now = System.currentTimeMillis();
        return this.activeModes.entrySet().stream().filter(e -> {
            Long exp = (Long)e.getValue();
            return !NO_EXPIRATION.equals(exp) && exp > now;
        }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Long)e.getValue()));
    }

    private Long modeExpiration(SettingDao dao, String mode) {
        if (dao == null) {
            return null;
        }
        String exp = dao.getSetting(SETTING_OP_MODE_EXPIRE, mode);
        if (exp != null) {
            try {
                return Long.valueOf(exp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Set<String> enableOperationalModes(Set<String> modes) {
        return this.enableOperationalModes(modes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<String> enableOperationalModes(Set<String> modes, Instant expire) {
        if (modes == null || modes.isEmpty()) {
            return this.activeOperationalModes();
        }
        HashSet<String> toActivate = null;
        Long expireMs = expire != null ? Long.valueOf(expire.toEpochMilli()) : null;
        for (String mode : modes) {
            if (mode == null) continue;
            mode = mode.toLowerCase();
            Long exp = (Long)this.activeModes.get(mode);
            if ((expireMs != null || NO_EXPIRATION.equals(exp)) && (expireMs == null || exp != null && expireMs.equals(exp))) continue;
            if (toActivate == null) {
                toActivate = new HashSet<String>();
            }
            toActivate.add(mode);
        }
        if (toActivate == null) {
            return this.activeOperationalModes();
        }
        SettingDao dao = (SettingDao)this.settingDao.service();
        if (dao == null) {
            return this.activeOperationalModes();
        }
        PlatformTransactionManager txManager = (PlatformTransactionManager)OptionalService.service(this.transactionManager);
        TransactionStatus tx = null;
        if (txManager != null) {
            tx = txManager.getTransaction(TX_RW);
        }
        try {
            for (String mode : toActivate) {
                this.activeModes.put(mode, expireMs != null ? expireMs : NO_EXPIRATION);
                dao.storeSetting(SETTING_OP_MODE, mode, mode);
                if (expire != null) {
                    dao.storeSetting(SETTING_OP_MODE_EXPIRE, mode, String.valueOf(expireMs));
                    continue;
                }
                dao.deleteSetting(SETTING_OP_MODE_EXPIRE, mode);
            }
            Set<String> active = this.activeOperationalModes();
            if (this.log.isInfoEnabled()) {
                this.log.info("Enabled operational modes [{}], expiring [{}]; active modes now [{}]", new Object[]{StringUtils.commaDelimitedStringFromCollection(modes), expire != null ? expire : "never", StringUtils.commaDelimitedStringFromCollection(active)});
            }
            this.postOperationalModesChangedEvent(active);
            Set<String> set = active;
            return set;
        }
        finally {
            if (tx != null) {
                txManager.commit(tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<String> disableOperationalModes(Set<String> modes) {
        Set<String> active = this.activeOperationalModes();
        if (modes == null || modes.isEmpty()) {
            return active;
        }
        LinkedHashSet<String> toDeactivate = null;
        for (String mode : modes) {
            if (mode == null || !active.contains(mode = mode.toLowerCase())) continue;
            if (toDeactivate == null) {
                toDeactivate = new LinkedHashSet<String>(modes.size());
            }
            toDeactivate.add(mode);
        }
        if (toDeactivate == null) {
            return active;
        }
        SettingDao dao = (SettingDao)this.settingDao.service();
        if (dao == null) {
            return Collections.emptySet();
        }
        PlatformTransactionManager txManager = (PlatformTransactionManager)OptionalService.service(this.transactionManager);
        TransactionStatus tx = null;
        if (txManager != null) {
            tx = txManager.getTransaction(TX_RW);
        }
        try {
            for (String mode : toDeactivate) {
                this.activeModes.remove(mode);
                dao.deleteSetting(SETTING_OP_MODE, mode);
                active.remove(mode);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Disabled operational modes [{}]; active modes now [{}]", (Object)StringUtils.commaDelimitedStringFromCollection(modes), (Object)StringUtils.commaDelimitedStringFromCollection(active));
            }
            this.postOperationalModesChangedEvent(active);
            Set<String> set = active;
            return set;
        }
        finally {
            if (tx != null) {
                txManager.commit(tx);
            }
        }
    }

    @Override
    public UUID registerOperationalModeInfo(OperationalModesService.OperationalModeInfo info) {
        UUID id = UUID.randomUUID();
        this.registeredModes.put(id, info);
        return id;
    }

    @Override
    public Stream<OperationalModesService.OperationalModeInfo> registeredOperationalModes() {
        return this.registeredModes.values().stream();
    }

    @Override
    public boolean unregisterOperationalModeInfo(UUID registrationId) {
        return this.registeredModes.remove(registrationId) != null;
    }

    private void postOperationalModesChangedEvent(Set<String> activeModes) {
        if (activeModes == null) {
            return;
        }
        Event event = this.createOperationalModesChangedEvent(activeModes);
        this.postEvent(event);
    }

    protected Event createOperationalModesChangedEvent(Set<String> activeModes) {
        if (activeModes == null) {
            activeModes = Collections.emptySet();
        }
        Map<String, Set<String>> props = Collections.singletonMap("ActiveOpModes", activeModes);
        return new Event("net/solarnetwork/node/OperationalModesService/MODES_CHANGED", props);
    }

    protected final void postEvent(Event event) {
        EventAdmin ea;
        EventAdmin eventAdmin = ea = this.eventAdmin == null ? null : (EventAdmin)this.eventAdmin.service();
        if (ea == null || event == null) {
            return;
        }
        ea.postEvent(event);
    }

    public void setStartupDelay(long startupDelay) {
        this.startupDelay = startupDelay;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setAutoExpireModesFrequency(int autoExpireModesFrequency) {
        if (autoExpireModesFrequency < 1) {
            throw new IllegalArgumentException("autoExpireModesFrequency must be > 0");
        }
        this.autoExpireModesFrequency = autoExpireModesFrequency;
    }

    public OptionalService<PlatformTransactionManager> getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(OptionalService<PlatformTransactionManager> transactionManager) {
        this.transactionManager = transactionManager;
    }

    static {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setReadOnly(false);
        TX_RW = def;
    }

    private final class AutoExpireModesTask
    implements Runnable {
        private AutoExpireModesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            HashSet<String> toDeactivate = null;
            for (Map.Entry me : DefaultOperationalModesService.this.activeModes.entrySet()) {
                Long exp = (Long)me.getValue();
                if (NO_EXPIRATION.equals(exp) || exp >= now) continue;
                if (toDeactivate == null) {
                    toDeactivate = new HashSet<String>(4);
                }
                toDeactivate.add((String)me.getKey());
            }
            if (toDeactivate == null) {
                return;
            }
            SettingDao dao = (SettingDao)DefaultOperationalModesService.this.settingDao.service();
            if (dao == null) {
                return;
            }
            PlatformTransactionManager txManager = (PlatformTransactionManager)OptionalService.service((OptionalService)DefaultOperationalModesService.this.transactionManager);
            TransactionStatus tx = null;
            if (txManager != null) {
                tx = txManager.getTransaction(TX_RW);
            }
            try {
                for (String mode : toDeactivate) {
                    dao.deleteSetting(DefaultOperationalModesService.SETTING_OP_MODE, mode);
                    dao.deleteSetting(DefaultOperationalModesService.SETTING_OP_MODE_EXPIRE, mode);
                    DefaultOperationalModesService.this.activeModes.remove(mode);
                }
                Set<String> newActive = DefaultOperationalModesService.this.activeOperationalModes();
                DefaultOperationalModesService.this.log.info("Expired operational modes [{}]; active modes now [{}]", (Object)StringUtils.commaDelimitedStringFromCollection(toDeactivate), (Object)StringUtils.commaDelimitedStringFromCollection(newActive));
                DefaultOperationalModesService.this.postOperationalModesChangedEvent(newActive);
            }
            finally {
                if (tx != null) {
                    txManager.commit(tx);
                }
            }
        }
    }
}

