/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Collection;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.node.dao.SecurityTokenDao;
import net.solarnetwork.node.domain.SecurityToken;
import net.solarnetwork.node.service.SecurityTokenService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.util.ObjectUtils;

public class DefaultSecurityTokenService
extends BaseIdentifiable
implements SecurityTokenService {
    private static final int TOKEN_ID_LEN = 20;
    private static final int TOKEN_SEC_LEN = 32;
    private static final char[] TOKEN_ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '-', '.', '_'};
    private final SecureRandom rng;
    private final OptionalService<SecurityTokenDao> securityTokenDao;

    public DefaultSecurityTokenService(OptionalService<SecurityTokenDao> securityTokenDao) {
        this(DefaultSecurityTokenService.defaultRng(), securityTokenDao);
    }

    public DefaultSecurityTokenService(SecureRandom rng, OptionalService<SecurityTokenDao> securityTokenDao) {
        this.rng = (SecureRandom)ObjectUtils.requireNonNullArgument((Object)rng, (String)"rng");
        this.securityTokenDao = (OptionalService)ObjectUtils.requireNonNullArgument(securityTokenDao, (String)"securityTokenDao");
    }

    private static SecureRandom defaultRng() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    }

    private SecurityTokenDao dao() {
        SecurityTokenDao dao = (SecurityTokenDao)OptionalService.service(this.securityTokenDao);
        if (dao != null) {
            return dao;
        }
        throw new UnsupportedOperationException("SecurityTokenDao not available.");
    }

    @Override
    public Collection<SecurityToken> getAvailableTokens() {
        return this.dao().getAll(null);
    }

    @Override
    public SecurityToken tokenForId(String tokenId) {
        return (SecurityToken)this.dao().get((String)ObjectUtils.requireNonNullArgument((Object)tokenId, (String)"tokenId"));
    }

    @Override
    public KeyValuePair createToken(SecurityToken details) {
        SecurityTokenDao dao = this.dao();
        String tokenId = this.generateRandomToken(20);
        String tokenSecret = this.generateRandomToken(32);
        SecurityToken token = new SecurityToken(tokenId, Instant.now(), tokenSecret, details != null ? details.getName() : null, details != null ? details.getDescription() : null);
        dao.save((Entity)token);
        return new KeyValuePair(tokenId, tokenSecret);
    }

    private String generateRandomToken(int length) {
        char[] data = new char[length];
        for (int i = 0; i < length; ++i) {
            data[i] = TOKEN_ALPHABET[this.rng.nextInt(TOKEN_ALPHABET.length)];
        }
        return new String(data);
    }

    @Override
    public void updateToken(SecurityToken token) {
        ObjectUtils.requireNonNullArgument((Object)((Object)token), (String)"token");
        String[] holder = new String[1];
        token.copySecret(s -> {
            holder[0] = s;
        });
        if (holder[0] != null) {
            throw new IllegalArgumentException("A token secret cannot be provided.");
        }
        this.dao().save((Entity)token);
    }

    @Override
    public void deleteToken(String tokenId) {
        ObjectUtils.requireNonNullArgument((Object)tokenId, (String)"tokenId");
        SecurityToken token = SecurityToken.tokenDetails(tokenId, null, null);
        this.dao().delete((Entity)token);
    }
}

