/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import net.solarnetwork.domain.Result;
import net.solarnetwork.node.service.DatumEvents;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StringUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.support.GenericMessage;

public class EventMessageBridge
implements EventHandler {
    public static final String NODE_EVENT_PREFIX = "net/solarnetwork/node/";
    public static final String MESSAGE_TOPIC_PREFIX = "/topic/";
    public static final String PUBLIC_MESSAGE_TOPIC_PREFIX = "/pub/topic/";
    private final OptionalService<SimpMessageSendingOperations> messageSendingOps;
    private final Executor executor;
    private Map<String, String> topicMapping;
    private Map<String, String> publicTopicMapping;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private static Map<String, String> defaultTopicMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("net/solarnetwork/node/service/DatumDataSource/DATUM_CAPTURED", "datum/captured/{sourceId}");
        map.put("net/solarnetwork/node/dao/DATUM_STORED", "datum/stored/{sourceId}");
        map.put("net/solarnetwork/node/service/UploadService/DATUM_UPLOADED", "datum/uploaded/{sourceId}");
        map.put("net/solarnetwork/node/service/NodeControlProvider/CONTROL_INFO_CAPTURED", "control/captured/{controlId}");
        map.put("net/solarnetwork/node/service/NodeControlProvider/CONTROL_INFO_CHANGED", "control/changed/{controlId}");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> defaultPublicTopicMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("net/solarnetwork/node/PlatformService/STATE_CHANGED", "platform/state");
        return Collections.unmodifiableMap(map);
    }

    public EventMessageBridge(OptionalService<SimpMessageSendingOperations> messageSendingOps) {
        this(messageSendingOps, null);
    }

    public EventMessageBridge(OptionalService<SimpMessageSendingOperations> messageSendingOps, Executor executor) {
        this.messageSendingOps = (OptionalService)ObjectUtils.requireNonNullArgument(messageSendingOps, (String)"messageSendingOps");
        this.executor = executor;
        this.topicMapping = EventMessageBridge.defaultTopicMapping();
        this.publicTopicMapping = EventMessageBridge.defaultPublicTopicMapping();
    }

    public void handleEvent(Event event) {
        Map<String, Object> data = DatumEvents.datumEventMap(event);
        String topic = this.messageTopicForEvent(event, data);
        if (topic == null) {
            return;
        }
        this.log.debug("Posting event {} to message topic {} with data {}", new Object[]{event.getTopic(), topic, data});
        if (this.executor != null) {
            this.executor.execute(() -> this.postMessage(topic, data));
        } else {
            this.postMessage(topic, data);
        }
    }

    private String messageTopicForEvent(Event event, Map<String, ?> data) {
        String val;
        boolean pubTopic = false;
        String topic = event.getTopic();
        if (this.topicMapping != null && (val = this.topicMapping.get(topic)) != null) {
            topic = val;
        }
        if (this.publicTopicMapping != null && (val = this.publicTopicMapping.get(topic)) != null) {
            topic = val;
            pubTopic = true;
        }
        if ((topic = StringUtils.expandTemplateString((String)topic, data)).startsWith(NODE_EVENT_PREFIX)) {
            topic = topic.substring(NODE_EVENT_PREFIX.length());
        }
        topic = topic.replaceAll("\\/\\/", "/");
        return (pubTopic ? PUBLIC_MESSAGE_TOPIC_PREFIX : MESSAGE_TOPIC_PREFIX) + topic;
    }

    protected void postMessage(String dest, Object body) {
        this.postMessage(dest, body, null, true);
    }

    protected void postMessage(String dest, Object body, Map<String, Object> headers, boolean convert) {
        SimpMessageSendingOperations ops;
        SimpMessageSendingOperations simpMessageSendingOperations = ops = this.messageSendingOps != null ? (SimpMessageSendingOperations)this.messageSendingOps.service() : null;
        if (ops == null) {
            return;
        }
        if (convert) {
            Result r = body instanceof Result ? (Result)body : Result.result((Object)body);
            ops.convertAndSend((Object)dest, (Object)r, headers);
        } else {
            GenericMessage msg = new GenericMessage(body, headers);
            ops.send((Object)dest, (Message)msg);
        }
    }

    public void setTopicMapping(Map<String, String> topicMapping) {
        this.topicMapping = topicMapping;
    }

    public void setPublicTopicMapping(Map<String, String> publicTopicMapping) {
        this.publicTopicMapping = publicTopicMapping;
    }
}

