/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionHandler;
import net.solarnetwork.node.reactor.InstructionStatus;
import net.solarnetwork.node.reactor.InstructionUtils;
import net.solarnetwork.node.service.NodeControlProvider;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StringUtils;
import org.springframework.util.AntPathMatcher;

public class SimpleNodeControlsService
extends BaseIdentifiable
implements InstructionHandler {
    public static final String CONTROLS_SERVICE_UID = "net.solarnetwork.node.controls";
    public static final String PARAM_FILTER = "filter";
    private final Collection<NodeControlProvider> providers;

    public SimpleNodeControlsService(Collection<NodeControlProvider> providers) {
        this.providers = (Collection)ObjectUtils.requireNonNullArgument(providers, (String)"providers");
    }

    @Override
    public boolean handlesTopic(String topic) {
        return "SystemConfiguration".equals(topic);
    }

    @Override
    public InstructionStatus processInstruction(Instruction instruction) {
        String serviceId;
        if (instruction == null || !this.handlesTopic(instruction.getTopic())) {
            return null;
        }
        String uid = this.getUid() != null ? this.getUid() : CONTROLS_SERVICE_UID;
        if (!uid.equals(serviceId = instruction.getParameterValue("service"))) {
            return null;
        }
        String filter = instruction.getParameterValue(PARAM_FILTER);
        AntPathMatcher pathMatcher = filter != null ? new AntPathMatcher() : null;
        TreeSet<String> controlIds = new TreeSet<String>();
        for (NodeControlProvider provider : this.providers) {
            List<String> ids = provider.getAvailableControlIds();
            if (ids == null) continue;
            if (pathMatcher == null) {
                controlIds.addAll(ids);
                continue;
            }
            for (String id : ids) {
                if (!pathMatcher.match(filter, id)) continue;
                controlIds.add(id);
            }
        }
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed, Collections.singletonMap("result", StringUtils.commaDelimitedStringFromCollection(controlIds)));
    }
}

