/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.solarnetwork.domain.InstructionStatus;
import net.solarnetwork.node.domain.Setting;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.node.reactor.InstructionHandler;
import net.solarnetwork.node.reactor.InstructionStatus;
import net.solarnetwork.node.reactor.InstructionUtils;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.node.settings.ExtendedSettingSpecifierProviderFactory;
import net.solarnetwork.node.settings.FileSettingSpecifier;
import net.solarnetwork.node.settings.LocationLookupSettingSpecifier;
import net.solarnetwork.node.settings.SettingsService;
import net.solarnetwork.node.settings.SetupResourceSettingSpecifier;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.FactorySettingSpecifierProvider;
import net.solarnetwork.settings.GroupSettingSpecifier;
import net.solarnetwork.settings.KeyedSettingSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.SettingSpecifierProviderFactory;
import net.solarnetwork.settings.support.SettingUtils;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.StringUtils;

public class SimpleNodeSettingsService
extends BaseIdentifiable
implements InstructionHandler {
    public static final String SETTINGS_SERVICE_UID = "net.solarnetwork.node.settings";
    public static final String PARAM_SETTING_UID = "uid";
    public static final String PARAM_INSTANCE_ID = "id";
    public static final String PARAM_SPECIFICATION = "spec";
    public static final String PARAM_COMPRESSED = "compress";
    public static final String ID_LIST = "*";
    public static final String REDACTED_VALUE = "*****";
    private static Pattern SENSITVE_PATTERN = Pattern.compile("(apikey|password|secret)", 2);
    private final OptionalService<SettingsService> settingsService;

    public SimpleNodeSettingsService(OptionalService<SettingsService> settingsService) {
        this.settingsService = (OptionalService)ObjectUtils.requireNonNullArgument(settingsService, (String)"settingsService");
    }

    @Override
    public boolean handlesTopic(String topic) {
        return "SystemConfiguration".equals(topic);
    }

    @Override
    public InstructionStatus processInstruction(Instruction instruction) {
        String serviceId;
        if (instruction == null || !this.handlesTopic(instruction.getTopic())) {
            return null;
        }
        String uid = this.getUid() != null ? this.getUid() : SETTINGS_SERVICE_UID;
        if (!uid.equals(serviceId = instruction.getParameterValue("service"))) {
            return null;
        }
        SettingsService service = (SettingsService)OptionalService.service(this.settingsService);
        if (service == null) {
            return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined, InstructionUtils.createErrorResultParameters("No SettingsService available.", "SNS.00001"));
        }
        String sid = instruction.getParameterValue(PARAM_SETTING_UID);
        String iid = instruction.getParameterValue(PARAM_INSTANCE_ID);
        if (iid != null && sid != null) {
            if (ID_LIST.equals(sid)) {
                return this.generateFactoryList(instruction, service);
            }
            SettingSpecifierProviderFactory f = service.getProviderFactory(sid);
            if (f == null) {
                return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined, InstructionUtils.createErrorResultParameters("Factory not available.", "SNS.00002"));
            }
            if (ID_LIST.equals(iid)) {
                return this.generateFactoryInstanceList(instruction, f);
            }
            return this.generateFactoryInstanceSettingsList(instruction, service, sid, iid);
        }
        if (sid != null) {
            if (ID_LIST.equals(sid)) {
                return this.generateProviderList(instruction, service);
            }
            return this.generateProviderSettingsList(instruction, service, sid);
        }
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined, InstructionUtils.createErrorResultParameters("Required parameter [uid] missing.", "SNS.00000"));
    }

    /*
     * Exception decompiling
     */
    private String jsonResult(Instruction instruction, Object obj, String defaultJson) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InstructionStatus generateFactoryInstanceList(Instruction instruction, SettingSpecifierProviderFactory f) {
        if (f instanceof ExtendedSettingSpecifierProviderFactory) {
            ExtendedSettingSpecifierProviderFactory ef = (ExtendedSettingSpecifierProviderFactory)f;
            Set<String> instanceIds = ef.getSettingSpecifierProviderInstanceIds();
            return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed, Collections.singletonMap("result", this.jsonResult(instruction, instanceIds, "[]")));
        }
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined, InstructionUtils.createErrorResultParameters("Factory instances not discoverable.", "SNS.00003"));
    }

    private InstructionStatus generateFactoryInstanceSettingsList(Instruction instruction, SettingsService service, String factoryId, String instanceId) {
        Map<String, FactorySettingSpecifierProvider> providers = service.getProvidersForFactory(factoryId);
        FactorySettingSpecifierProvider provider = providers.get(instanceId);
        if (provider == null) {
            return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined, InstructionUtils.createErrorResultParameters("Factory instance provider not available.", "SNS.00004"));
        }
        List<Map<String, Object>> result = StringUtils.parseBoolean((String)instruction.getParameterValue(PARAM_SPECIFICATION)) ? this.resultSpecification(service, (SettingSpecifierProvider)provider) : this.resultSettings(service, (SettingSpecifierProvider)provider);
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed, Collections.singletonMap("result", this.jsonResult(instruction, result, "[]")));
    }

    private InstructionStatus generateProviderSettingsList(Instruction instruction, SettingsService service, String settingsUid) {
        SettingSpecifierProvider provider = service.getProviders().stream().filter(p -> settingsUid.equals(p.getSettingUid())).findAny().orElse(null);
        if (provider == null) {
            return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Declined, InstructionUtils.createErrorResultParameters("Provider not available.", "SNS.00005"));
        }
        List<Map<String, Object>> result = StringUtils.parseBoolean((String)instruction.getParameterValue(PARAM_SPECIFICATION)) ? this.resultSpecification(service, provider) : this.resultSettings(service, provider);
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed, Collections.singletonMap("result", this.jsonResult(instruction, result, "[]")));
    }

    private InstructionStatus generateFactoryList(Instruction instruction, SettingsService service) {
        List<SettingSpecifierProviderFactory> factories = service.getProviderFactories();
        ArrayList results = new ArrayList(factories.size());
        for (SettingSpecifierProviderFactory f : factories) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(2);
            props.put(PARAM_INSTANCE_ID, f.getFactoryUid());
            String title = f.getDisplayName();
            if (f.getMessageSource() != null) {
                title = f.getMessageSource().getMessage("title", null, title, Locale.getDefault());
            }
            props.put("title", title);
            results.add(props);
        }
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed, Collections.singletonMap("result", this.jsonResult(instruction, results, "[]")));
    }

    private InstructionStatus generateProviderList(Instruction instruction, SettingsService service) {
        List<SettingSpecifierProvider> providers = service.getProviders();
        ArrayList results = new ArrayList(providers.size());
        for (SettingSpecifierProvider p : providers) {
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(2);
            props.put(PARAM_INSTANCE_ID, p.getSettingUid());
            String title = p.getDisplayName();
            if (p.getMessageSource() != null) {
                title = p.getMessageSource().getMessage("title", null, title, Locale.getDefault());
            }
            props.put("title", title);
            results.add(props);
        }
        return InstructionUtils.createStatus(instruction, InstructionStatus.InstructionState.Completed, Collections.singletonMap("result", this.jsonResult(instruction, results, "[]")));
    }

    private List<Map<String, Object>> resultSettings(SettingsService service, SettingSpecifierProvider provider) {
        Map<String, Setting> settingsMap;
        String instanceId = provider instanceof FactorySettingSpecifierProvider ? ((FactorySettingSpecifierProvider)provider).getFactoryInstanceUID() : null;
        List specs = provider.getSettingSpecifiers();
        List<Setting> settings = service.getSettings(instanceId != null ? provider.getSettingUid() : null, instanceId != null ? instanceId : provider.getSettingUid());
        if (settings != null && !settings.isEmpty()) {
            settingsMap = new HashMap(settings.size());
            for (Setting s : settings) {
                settingsMap.put(s.getType(), s);
            }
        } else {
            settingsMap = Collections.emptyMap();
        }
        ArrayList<Map<String, Object>> resultSettings = new ArrayList<Map<String, Object>>(specs.size());
        for (SettingSpecifier spec : specs) {
            this.generateResultSetting(resultSettings, settingsMap, spec);
        }
        return resultSettings;
    }

    private void generateResultSetting(List<Map<String, Object>> resultSettings, Map<String, Setting> settingsMap, SettingSpecifier spec) {
        if (spec instanceof KeyedSettingSpecifier) {
            KeyedSettingSpecifier keyedSpec = (KeyedSettingSpecifier)spec;
            if (keyedSpec.isTransient()) {
                return;
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(4);
            props.put("key", keyedSpec.getKey());
            Setting setting = settingsMap.get(keyedSpec.getKey());
            props.put("value", setting != null ? SimpleNodeSettingsService.settingValue(setting) : keyedSpec.getDefaultValue());
            if (setting == null) {
                props.put("default", true);
            }
            resultSettings.add(props);
        } else if (spec instanceof GroupSettingSpecifier) {
            GroupSettingSpecifier group = (GroupSettingSpecifier)spec;
            for (SettingSpecifier groupSpec : group.getGroupSettings()) {
                this.generateResultSetting(resultSettings, settingsMap, groupSpec);
            }
        }
    }

    private static String settingValue(Setting setting) {
        String key = setting.getType();
        String value = setting.getValue();
        if (value != null && key != null && SENSITVE_PATTERN.matcher(key).find()) {
            value = REDACTED_VALUE;
        }
        return value;
    }

    private List<Map<String, Object>> resultSpecification(SettingsService service, SettingSpecifierProvider provider) {
        return SettingUtils.templateSpecification((SettingSpecifierProvider)provider, (spec, props) -> {
            if (spec instanceof FileSettingSpecifier) {
                FileSettingSpecifier file = (FileSettingSpecifier)spec;
                props.put("acceptableFileTypeSpecifiers", file.getAcceptableFileTypeSpecifiers());
                if (file.isMultiple()) {
                    props.put("multiple", file.isMultiple());
                }
            } else if (spec instanceof LocationLookupSettingSpecifier) {
                LocationLookupSettingSpecifier look = (LocationLookupSettingSpecifier)spec;
                props.put("locationTypeKey", look.getLocationTypeKey());
            } else if (spec instanceof SetupResourceSettingSpecifier) {
                SetupResourceSettingSpecifier setup = (SetupResourceSettingSpecifier)spec;
                props.put("setupResourceProperties", setup.getSetupResourceProperties());
            }
        });
    }
}

