/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.MutableDatum;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.util.ClassUtils;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatumEvents {
    private static final Logger log = LoggerFactory.getLogger(DatumEvents.class);
    public static final String DATUM_PROPERTY = "_Datum";
    private static final ConcurrentMap<Class<?>, String[]> DATUM_TYPE_CACHE = new ConcurrentHashMap();

    private DatumEvents() {
    }

    public static Event datumEvent(String topic, Class<? extends Datum> clazz, Map<String, ?> datumMap) {
        if (datumMap == null || datumMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(datumMap.size());
        for (Map.Entry<String, ?> me : datumMap.entrySet()) {
            String k = me.getKey();
            Object o = datumMap.get(k);
            if (o instanceof Map) {
                for (Map.Entry e : ((Map)o).entrySet()) {
                    props.put(e.getKey().toString(), e.getValue());
                }
                continue;
            }
            props.put(k, o);
        }
        String[] types = DatumEvents.datumTypes(clazz);
        if (types != null && types.length > 0) {
            props.put("_DatumType", types[0]);
            props.put("_DatumTypes", types);
        }
        if (log.isTraceEnabled()) {
            log.trace("Created {} event with props {}", (Object)topic, props);
        }
        return new Event(topic, props);
    }

    public static Event datumEvent(String topic, NodeDatum datum) {
        Map<String, NodeDatum> props;
        if (datum == null) {
            return new Event(topic, Collections.emptyMap());
        }
        String[] datumTypes = DatumEvents.datumTypes(datum.getClass());
        if (datumTypes != null && datumTypes.length > 0) {
            props = new LinkedHashMap<String, NodeDatum>(3);
            props.put("_DatumType", (NodeDatum)((Object)datumTypes[0]));
            props.put("_DatumTypes", (NodeDatum)datumTypes);
            props.put(DATUM_PROPERTY, datum);
        } else {
            props = Collections.singletonMap(DATUM_PROPERTY, datum);
        }
        if (log.isTraceEnabled()) {
            log.trace("Created {} event with props {}", (Object)topic, props);
        }
        return new Event(topic, props);
    }

    public static Map<String, Object> datumEventMap(Event event) {
        String[] propNames = event.getPropertyNames();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(propNames.length);
        for (String propName : propNames) {
            Object val = event.getProperty(propName);
            if (DATUM_PROPERTY.equals(propName) && val instanceof NodeDatum) {
                map.putAll(((NodeDatum)val).asSimpleMap());
                continue;
            }
            if (val == null) continue;
            map.put(propName, val);
        }
        return map;
    }

    public static Event datumCapturedEvent(NodeDatum datum) {
        return DatumEvents.datumEvent("net/solarnetwork/node/service/DatumDataSource/DATUM_CAPTURED", datum);
    }

    public static String[] datumTypes(Class<?> clazz) {
        String[] result = (String[])DATUM_TYPE_CACHE.get(clazz);
        if (result != null) {
            return result;
        }
        Set interfaces = ClassUtils.getAllNonJavaInterfacesForClassAsSet(clazz);
        Iterator itr = interfaces.iterator();
        while (itr.hasNext()) {
            Class c = (Class)itr.next();
            if (Datum.class.isAssignableFrom(c) && !MutableDatum.class.isAssignableFrom(c)) continue;
            itr.remove();
        }
        result = new String[interfaces.size()];
        int i = 0;
        for (Class intf : interfaces) {
            result[i] = intf.getName();
            ++i;
        }
        DATUM_TYPE_CACHE.putIfAbsent(clazz, result);
        return result;
    }
}

