/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.solarnetwork.node.reactor.Instruction;
import net.solarnetwork.util.ObjectUtils;
import org.osgi.service.event.Event;

public interface OperationalModesService {
    public static final String TOPIC_ENABLE_OPERATIONAL_MODES = "EnableOperationalModes";
    public static final String TOPIC_DISABLE_OPERATIONAL_MODES = "DisableOperationalModes";
    public static final String INSTRUCTION_PARAM_OPERATIONAL_MODE = "OpMode";
    public static final String INSTRUCTION_PARAM_EXPIRATION = "Expiration";
    public static final String EVENT_TOPIC_OPERATIONAL_MODES_CHANGED = "net/solarnetwork/node/OperationalModesService/MODES_CHANGED";
    public static final String EVENT_PARAM_ACTIVE_OPERATIONAL_MODES = "ActiveOpModes";

    public boolean isOperationalModeActive(String var1);

    public Set<String> activeOperationalModes();

    public Map<String, Long> activeOperationalModesWithExpirations();

    public Set<String> enableOperationalModes(Set<String> var1);

    public Set<String> enableOperationalModes(Set<String> var1, Instant var2);

    public Set<String> disableOperationalModes(Set<String> var1);

    public static boolean hasActiveOperationalMode(Event event, String mode) {
        Object v;
        Object object = v = event != null ? event.getProperty(EVENT_PARAM_ACTIVE_OPERATIONAL_MODES) : null;
        if (!(v instanceof Set)) {
            return false;
        }
        if (mode == null || mode.isEmpty()) {
            return true;
        }
        mode = mode.toLowerCase();
        return ((Set)v).contains(mode);
    }

    public static Instant expirationDate(Instruction instruction) {
        String s;
        String string = s = instruction != null ? instruction.getParameterValue(INSTRUCTION_PARAM_EXPIRATION) : null;
        if (s == null) {
            return null;
        }
        try {
            return Instant.ofEpochMilli(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public UUID registerOperationalModeInfo(OperationalModeInfo var1);

    public Stream<OperationalModeInfo> registeredOperationalModes();

    public boolean unregisterOperationalModeInfo(UUID var1);

    public static Predicate<OperationalModeInfo> withPrefix(String prefix) {
        return e -> ((OperationalModeInfo)e).name.startsWith(prefix);
    }

    public static Predicate<OperationalModeInfo> withTag(String tag) {
        return e -> ((OperationalModeInfo)e).tags != null && ((OperationalModeInfo)e).tags.contains(tag);
    }

    public static Predicate<OperationalModeInfo> withPrefixAndTag(String prefix, String tag) {
        return e -> ((OperationalModeInfo)e).name.startsWith(prefix) && ((OperationalModeInfo)e).tags != null && ((OperationalModeInfo)e).tags.contains(tag);
    }

    public static final class OperationalModeInfo {
        private final String name;
        private final Set<String> tags;

        public OperationalModeInfo(String name) {
            this(name, null);
        }

        public OperationalModeInfo(String name, Set<String> tags) {
            this.name = (String)ObjectUtils.requireNonNullArgument((Object)name, (String)"name");
            this.tags = tags != null ? tags : Collections.emptySet();
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getTags() {
            return this.tags;
        }
    }
}

