/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.Hashtable;
import java.util.Map;
import net.solarnetwork.common.osgi.service.BaseServiceListener;
import net.solarnetwork.common.osgi.service.RegisteredService;
import net.solarnetwork.node.service.BeanConfiguration;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class BeanConfigurationServiceRegistrationListener
extends BaseServiceListener<BeanConfiguration, BeanConfigurationRegisteredService> {
    private Class<?> serviceClass = null;
    private String[] serviceInterfaces = null;
    private Map<String, Object> serviceProperties = null;

    public BeanConfigurationServiceRegistrationListener(BundleContext bundleContext) {
        super(bundleContext);
    }

    public void onBind(BeanConfiguration config, Map<String, ?> properties) {
        Object service;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Bind called on [" + config + "] with props " + properties);
        }
        try {
            service = this.serviceClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (this.serviceProperties != null) {
            props.putAll(this.serviceProperties);
        }
        if (config.getAttributes() != null) {
            props.putAll(config.getAttributes());
        }
        props.put("service.ranking", config.getOrdering());
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(service);
        wrapper.setPropertyValues(config.getConfiguration());
        this.addRegisteredService(new BeanConfigurationRegisteredService(config, properties), service, this.serviceInterfaces, props);
    }

    public void onUnbind(BeanConfiguration config, Map<String, ?> properties) {
        if (config == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Unbind called on [" + config + "] with props " + properties);
        }
        this.removeRegisteredService(config, properties);
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String[] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public void setServiceInterfaces(String[] serviceInterfaces) {
        this.serviceInterfaces = serviceInterfaces;
    }

    public Map<String, Object> getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Map<String, Object> serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public static class BeanConfigurationRegisteredService
    extends RegisteredService<BeanConfiguration> {
        public BeanConfigurationRegisteredService(BeanConfiguration config, Map<String, ?> properties) {
            super((Object)config, properties);
        }

        public boolean isSameAs(BeanConfiguration other, Map<String, ?> properties) {
            if (super.isSameAs((Object)other, properties)) {
                if (!BeanConfigurationRegisteredService.areMapsSame(((BeanConfiguration)this.getConfig()).getConfiguration(), other.getConfiguration())) {
                    return false;
                }
                return BeanConfigurationRegisteredService.areMapsSame(((BeanConfiguration)this.getConfig()).getAttributes(), other.getAttributes());
            }
            return false;
        }
    }
}

