/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import net.solarnetwork.domain.KeyValuePair;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import net.solarnetwork.node.domain.ExpressionRoot;
import net.solarnetwork.node.domain.datum.MutableNodeDatum;
import net.solarnetwork.node.domain.datum.NodeDatum;
import net.solarnetwork.node.service.DatumDataSource;
import net.solarnetwork.node.service.DatumMetadataService;
import net.solarnetwork.node.service.DatumQueue;
import net.solarnetwork.node.service.DatumService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.node.service.support.ExpressionConfig;
import net.solarnetwork.service.DatumFilterService;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicToggleSettingSpecifier;
import net.solarnetwork.util.ArrayUtils;
import org.springframework.scheduling.TaskScheduler;

public class DatumDataSourceSupport
extends BaseIdentifiable {
    public static final Map<String, Object> SUB_SAMPLE_PROPS = Collections.singletonMap("subsample", true);
    private static final ConcurrentMap<String, GeneralDatumMetadata> SOURCE_METADATA_CACHE = new ConcurrentHashMap<String, GeneralDatumMetadata>(8, 0.9f, 2);
    public static final long DEFAULT_SUBSAMPLE_START_DELAY = 15000L;
    public static final boolean DEFAULT_PUBLISH_DEVICE_INFO_METADATA = true;
    private OptionalService<DatumMetadataService> datumMetadataService;
    private OptionalService<DatumQueue> datumQueue;
    private OptionalService<DatumService> datumService;
    private TaskScheduler taskScheduler = null;
    private Long subSampleFrequency = null;
    private long subSampleStartDelay = 15000L;
    private OptionalService.OptionalFilterableService<DatumFilterService> datumFilterService;
    private ExpressionConfig[] expressionConfigs;
    private boolean publishDeviceInfoMetadata = true;
    private ScheduledFuture<?> subSampleFuture;

    public static final void clearSourceMetadataCache() {
        SOURCE_METADATA_CACHE.clear();
    }

    protected final void offerDatumCapturedEvent(NodeDatum datum) {
        DatumQueue queue;
        if (datum != null && (queue = (DatumQueue)OptionalService.service(this.datumQueue)) != null) {
            queue.offer(datum, false);
        }
    }

    protected boolean addSourceMetadata(String sourceId, GeneralDatumMetadata meta) {
        String resolvedSourceId = this.resolvePlaceholders(sourceId);
        if (resolvedSourceId == null) {
            return false;
        }
        GeneralDatumMetadata cached = (GeneralDatumMetadata)SOURCE_METADATA_CACHE.get(resolvedSourceId);
        if (cached != null && meta.equals((Object)cached)) {
            this.log.debug("Source {} metadata already added, not posting again", (Object)resolvedSourceId);
            return true;
        }
        DatumMetadataService service = null;
        if (this.datumMetadataService != null) {
            service = (DatumMetadataService)this.datumMetadataService.service();
        }
        if (service == null) {
            return false;
        }
        try {
            service.addSourceMetadata(resolvedSourceId, meta);
            SOURCE_METADATA_CACHE.put(resolvedSourceId, meta);
            return true;
        }
        catch (Exception e) {
            this.log.warn("Error saving source {} metadata: {}", (Object)resolvedSourceId, (Object)e.getMessage());
            return false;
        }
    }

    protected List<SettingSpecifier> getIdentifiableSettingSpecifiers() {
        return DatumDataSourceSupport.baseIdentifiableSettings("");
    }

    protected List<SettingSpecifier> getSubSampleSettingSpecifiers() {
        ArrayList<SettingSpecifier> results = new ArrayList<SettingSpecifier>(16);
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("datumFilterService.propertyFilters['uid']", null));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("subSampleFrequency", null));
        results.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("subSampleStartDelay", String.valueOf(15000L)));
        return results;
    }

    protected List<SettingSpecifier> getDeviceInfoMetadataSettingSpecifiers() {
        return Collections.singletonList(new BasicToggleSettingSpecifier("publishDeviceInfoMetadata", (Object)true));
    }

    public boolean canPublishDeviceInfo() {
        return this.isPublishDeviceInfoMetadata();
    }

    protected synchronized ScheduledFuture<?> startSubSampling(final DatumDataSource dataSource) {
        ScheduledFuture f;
        long freq;
        this.stopSubSampling();
        long l = freq = this.subSampleFrequency != null ? this.subSampleFrequency : 0L;
        if (this.taskScheduler == null || freq < 1L) {
            return null;
        }
        this.log.info("Starting sub-sampling @ {}ms, after {}ms delay in {}", new Object[]{freq, this.subSampleStartDelay, this});
        this.subSampleFuture = f = this.taskScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    DatumDataSourceSupport.this.readSubSampleDatum(dataSource);
                }
                catch (Exception e) {
                    DatumDataSourceSupport.this.log.warn("Error reading sub-sample datum for {}", (Object)DatumDataSourceSupport.this, (Object)e);
                }
            }
        }, new Date(System.currentTimeMillis() + this.subSampleStartDelay), freq);
        return f;
    }

    protected void readSubSampleDatum(DatumDataSource dataSource) {
        NodeDatum datum = dataSource.readCurrentDatum();
        this.log.debug("Got sub-sample datum: {}", (Object)datum);
    }

    protected synchronized void stopSubSampling() {
        if (this.subSampleFuture != null) {
            this.log.info("Stopping sub-sampling in {}", (Object)this);
            this.subSampleFuture.cancel(true);
            this.subSampleFuture = null;
        }
    }

    protected boolean isSubSampling() {
        ScheduledFuture<?> f = this.subSampleFuture;
        return f != null && !f.isDone();
    }

    protected NodeDatum applyDatumFilter(NodeDatum datum, Map<String, Object> props) {
        DatumFilterService xformService = (DatumFilterService)OptionalService.service(this.getDatumFilterService());
        if (xformService != null) {
            DatumSamplesOperations out = xformService.filter((Datum)datum, datum.asSampleOperations(), props);
            if (out == null) {
                return null;
            }
            if (out != datum.asSampleOperations()) {
                datum = datum.copyWithSamples(out);
            }
        }
        return datum;
    }

    protected void populateExpressionDatumProperties(MutableNodeDatum d, ExpressionConfig[] expressionConfs) {
        this.populateExpressionDatumProperties(d, expressionConfs, (Object)new ExpressionRoot(d, null, null, (DatumService)OptionalService.service(this.datumService)));
    }

    protected void populateExpressionDatumProperties(MutableNodeDatum d, ExpressionConfig[] expressionConfs, Object root) {
        super.populateExpressionDatumProperties(d.asMutableSampleOperations(), expressionConfs, root);
    }

    protected void saveMetadata(String sourceId) {
        if (sourceId == null || sourceId.isEmpty()) {
            return;
        }
        KeyValuePair[] data = this.getMetadata();
        if (data == null || data.length < 1) {
            return;
        }
        GeneralDatumMetadata meta = new GeneralDatumMetadata();
        meta.populate(data);
        try {
            this.addSourceMetadata(sourceId, meta);
        }
        catch (Exception e) {
            this.log.warn("Error saving metadata values {} for source [{}]: {}", new Object[]{meta, this.resolvePlaceholders(sourceId), e});
        }
    }

    public OptionalService<DatumMetadataService> getDatumMetadataService() {
        return this.datumMetadataService;
    }

    public void setDatumMetadataService(OptionalService<DatumMetadataService> datumMetadataService) {
        this.datumMetadataService = datumMetadataService;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public Long getSubSampleFrequency() {
        return this.subSampleFrequency;
    }

    public void setSubSampleFrequency(Long subSampleFrequency) {
        this.subSampleFrequency = subSampleFrequency;
    }

    public long getSubSampleStartDelay() {
        return this.subSampleStartDelay;
    }

    public void setSubSampleStartDelay(long subSampleStartDelay) {
        this.subSampleStartDelay = subSampleStartDelay;
    }

    public OptionalService.OptionalFilterableService<DatumFilterService> getDatumFilterService() {
        return this.datumFilterService;
    }

    public void setDatumFilterService(OptionalService.OptionalFilterableService<DatumFilterService> datumFilterService) {
        this.datumFilterService = datumFilterService;
    }

    public ExpressionConfig[] getExpressionConfigs() {
        return this.expressionConfigs;
    }

    public void setExpressionConfigs(ExpressionConfig[] expressionConfigs) {
        this.expressionConfigs = expressionConfigs;
    }

    public int getExpressionConfigsCount() {
        ExpressionConfig[] confs = this.expressionConfigs;
        return confs == null ? 0 : confs.length;
    }

    public void setExpressionConfigsCount(int count) {
        this.expressionConfigs = (ExpressionConfig[])ArrayUtils.arrayWithLength((Object[])this.expressionConfigs, (int)count, ExpressionConfig.class, null);
    }

    public boolean isPublishDeviceInfoMetadata() {
        return this.publishDeviceInfoMetadata;
    }

    public void setPublishDeviceInfoMetadata(boolean publishDeviceInfoMetadata) {
        this.publishDeviceInfoMetadata = publishDeviceInfoMetadata;
    }

    public OptionalService<DatumQueue> getDatumQueue() {
        return this.datumQueue;
    }

    public void setDatumQueue(OptionalService<DatumQueue> datumQueue) {
        this.datumQueue = datumQueue;
    }

    public OptionalService<DatumService> getDatumService() {
        return this.datumService;
    }

    public void setDatumService(OptionalService<DatumService> datumService) {
        this.datumService = datumService;
    }
}

