/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.node.service.support.BaseDatumFilterSupport;
import net.solarnetwork.service.DatumFilterService;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.SettingSpecifierProvider;
import net.solarnetwork.settings.support.BasicGroupSettingSpecifier;
import net.solarnetwork.settings.support.BasicTextFieldSettingSpecifier;
import net.solarnetwork.settings.support.BasicTitleSettingSpecifier;
import net.solarnetwork.settings.support.SettingUtils;
import net.solarnetwork.util.ArrayUtils;
import net.solarnetwork.util.WeakValueConcurrentHashMap;

public class DatumFilterChainService
extends BaseDatumFilterSupport
implements DatumFilterService,
SettingSpecifierProvider {
    private final String settingUid;
    private final List<DatumFilterService> transformServices;
    private final boolean configurableUid;
    private final DatumFilterService staticService;
    private String[] transformUids;
    private List<DatumFilterService> alternateDatumFilterServices;
    private boolean ignoreTransformUids;
    private final ConcurrentMap<String, DatumFilterService> serviceCache = new WeakValueConcurrentHashMap(16, 0.9f, 2);

    public DatumFilterChainService(String settingUid, List<DatumFilterService> transformServices) {
        this(settingUid, transformServices, true, null);
    }

    public DatumFilterChainService(String settingUid, List<DatumFilterService> transformServices, boolean configurableUid) {
        this(settingUid, transformServices, configurableUid, null);
    }

    public DatumFilterChainService(String settingUid, List<DatumFilterService> transformServices, boolean configurableUid, DatumFilterService staticService) {
        if (settingUid == null || settingUid.isEmpty()) {
            throw new IllegalArgumentException("The settingUid argument must not be null.");
        }
        this.settingUid = settingUid;
        if (transformServices == null) {
            throw new IllegalArgumentException("The transformServices argument must not be null.");
        }
        this.transformServices = transformServices;
        this.configurableUid = configurableUid;
        this.staticService = staticService;
        this.ignoreTransformUids = false;
    }

    public String getSettingUid() {
        return this.settingUid;
    }

    public List<SettingSpecifier> getSettingSpecifiers() {
        ArrayList<SettingSpecifier> result = new ArrayList<SettingSpecifier>(8);
        if (this.alternateDatumFilterServices != null) {
            result.add((SettingSpecifier)new BasicTitleSettingSpecifier("availableAlternateDatumFilterUids", this.availableAlternateDatumFilterUidsStatus(), true, true));
        }
        result.add((SettingSpecifier)new BasicTitleSettingSpecifier("availableUids", this.availableUidsStatus(), true, true));
        if (this.configurableUid) {
            result.addAll(DatumFilterChainService.baseIdentifiableSettings(""));
            result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("requiredOperationalMode", null));
            result.add((SettingSpecifier)new BasicTextFieldSettingSpecifier("requiredTag", null));
        }
        this.populateStatusSettings(result);
        String[] uids = this.getTransformUids();
        List<Object> uidsList = uids != null ? Arrays.asList(uids) : Collections.emptyList();
        BasicGroupSettingSpecifier uidsGroup = SettingUtils.dynamicListSettingSpecifier((String)"transformUids", uidsList, (SettingUtils.KeyedListCallback)new SettingUtils.KeyedListCallback<String>(){

            public Collection<SettingSpecifier> mapListSettingKey(String value, int index, String key) {
                return Collections.singletonList(new BasicTextFieldSettingSpecifier(key, ""));
            }
        });
        result.add((SettingSpecifier)uidsGroup);
        return result;
    }

    private String availableAlternateDatumFilterUidsStatus() {
        ArrayList<String> names = new ArrayList<String>();
        for (DatumFilterService s : this.alternateDatumFilterServices) {
            names.add(s.getDescription());
        }
        if (names.isEmpty()) {
            return "N/A";
        }
        Collections.sort(names, String::compareToIgnoreCase);
        StringBuilder buf = new StringBuilder("<ol>");
        for (String uid : names) {
            buf.append("<li>").append(uid).append("</li>");
        }
        buf.append("</ol>");
        return buf.toString();
    }

    private String availableUidsStatus() {
        ArrayList<String> uids = new ArrayList<String>();
        for (DatumFilterService s : this.transformServices) {
            String uid = s.getUid();
            if (uid == null || uid.isEmpty() || uid.equalsIgnoreCase(this.getUid())) continue;
            uids.add(uid);
        }
        if (uids.isEmpty()) {
            return "N/A";
        }
        Collections.sort(uids, String::compareToIgnoreCase);
        StringBuilder buf = new StringBuilder("<ol>");
        for (String uid : uids) {
            buf.append("<li>").append(uid).append("</li>");
        }
        buf.append("</ol>");
        return buf.toString();
    }

    private DatumFilterService findService(String uid) {
        return this.serviceCache.compute(uid, (k, v) -> {
            try {
                if (v != null && uid.equals(v.getUid())) {
                    return v;
                }
                for (DatumFilterService s : this.transformServices) {
                    String serviceUid = s.getUid();
                    if (!uid.equals(serviceUid)) continue;
                    return s;
                }
            }
            catch (Exception e) {
                this.log.warn("Discarding cached service [{}] because of exception: {}", (Object)uid, (Object)e.toString());
            }
            return null;
        });
    }

    public DatumSamplesOperations filter(Datum datum, DatumSamplesOperations samples, Map<String, Object> parameters) {
        long start = this.incrementInputStats();
        if (!this.conditionsMatch(datum, samples, parameters)) {
            this.incrementIgnoredStats(start);
            return samples;
        }
        Map<String, Object> p = parameters;
        DatumSamplesOperations out = samples;
        if (this.staticService != null) {
            if (p == null) {
                p = new HashMap<String, Object>(8);
            }
            if ((out = this.staticService.filter(datum, out, parameters)) == null) {
                this.incrementStats(start, samples, out);
                return null;
            }
        }
        if (this.ignoreTransformUids) {
            if (this.transformServices != null) {
                for (DatumFilterService s : this.transformServices) {
                    out = s.filter(datum, out, parameters);
                    if (out != null) continue;
                    this.incrementStats(start, samples, out);
                    return null;
                }
            }
        } else {
            String[] uids = this.getTransformUids();
            if (uids == null || uids.length < 1) {
                this.incrementStats(start, samples, out);
                return out;
            }
            for (String uid : uids) {
                DatumFilterService s;
                if (uid == null || uid.isEmpty() || (s = this.findService(uid)) == null) continue;
                if (p == null) {
                    p = new HashMap<String, Object>(8);
                }
                if ((out = s.filter(datum, out, p)) != null) continue;
                this.incrementStats(start, samples, out);
                return null;
            }
        }
        this.incrementStats(start, samples, out);
        return out;
    }

    public String[] getTransformUids() {
        return this.transformUids;
    }

    public void setTransformUids(String[] transformUids) {
        this.transformUids = transformUids;
    }

    public int getTransformUidsCount() {
        String[] uids = this.getTransformUids();
        return uids != null ? uids.length : 0;
    }

    public void setTransformUidsCount(int count) {
        this.transformUids = (String[])ArrayUtils.arrayWithLength((Object[])this.transformUids, (int)count, String.class, null);
    }

    public void setAlternateDatumFilterServices(List<DatumFilterService> alternateDatumFilterServices) {
        this.alternateDatumFilterServices = alternateDatumFilterServices;
    }

    public boolean isIgnoreTransformUids() {
        return this.ignoreTransformUids;
    }

    public void setIgnoreTransformUids(boolean ignoreTransformUids) {
        this.ignoreTransformUids = ignoreTransformUids;
    }
}

