/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.solarnetwork.io.UrlUtils;
import net.solarnetwork.node.service.IdentityService;
import net.solarnetwork.node.service.support.BaseIdentifiable;
import net.solarnetwork.security.AuthorizationUtils;
import net.solarnetwork.security.Snws2AuthorizationBuilder;
import net.solarnetwork.service.OptionalService;
import net.solarnetwork.service.SSLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public abstract class HttpClientSupport
extends BaseIdentifiable {
    public static final String ACCEPT_TEXT = "text/*";
    public static final String ACCEPT_JSON = "application/json,text/json";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 55000;
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    private int connectionTimeout = 55000;
    private IdentityService identityService = null;
    private OptionalService<SSLService> sslService = null;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected InputStream getInputStreamFromURLConnection(URLConnection conn) throws IOException {
        return UrlUtils.getInputStreamFromURLConnection((Logger)this.log, (URLConnection)conn);
    }

    protected Reader getUnicodeReaderFromURLConnection(URLConnection conn) throws IOException {
        return UrlUtils.getUnicodeReaderFromURLConnection((Logger)this.log, (URLConnection)conn);
    }

    protected URLConnection getURLConnection(String url, String httpMethod) throws IOException {
        return this.getURLConnection(url, httpMethod, ACCEPT_TEXT);
    }

    protected URLConnection getURLConnection(String url, String httpMethod, String accept) throws IOException {
        return this.getURLConnection(url, httpMethod, accept, null);
    }

    protected URLConnection getURLConnection(String url, String httpMethod, String accept, Consumer<URLConnection> connectionCustomizer) throws IOException {
        URLConnection conn = UrlUtils.getURLConnection((String)url, (String)httpMethod, (String)accept, (int)this.connectionTimeout, (SSLService)((SSLService)OptionalService.service(this.sslService)));
        if (connectionCustomizer != null) {
            connectionCustomizer.accept(conn);
        }
        return conn;
    }

    public void setupTokenAuthorization(URLConnection conn, Snws2AuthorizationBuilder builder, Instant requestDate, Map<String, List<String>> headers) {
        if (headers != null) {
            for (Map.Entry<String, List<String>> me : headers.entrySet()) {
                boolean first = true;
                for (String v : me.getValue()) {
                    if (first) {
                        conn.setRequestProperty(me.getKey(), v);
                        continue;
                    }
                    conn.addRequestProperty(me.getKey(), v);
                }
            }
        }
        builder.date(requestDate);
        URL url = conn.getURL();
        String host = url.getHost();
        int port = url.getPort();
        if (port != 80 && port != -1) {
            host = host + ":" + port;
        }
        ((Snws2AuthorizationBuilder)builder.host(host)).path(url.getPath());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Canonical request data: {}", (Object)builder.computeCanonicalRequestMessage());
        }
        conn.setRequestProperty("Date", AuthorizationUtils.AUTHORIZATION_DATE_HEADER_FORMATTER.format(requestDate));
        conn.setRequestProperty("Authorization", builder.build());
    }

    protected void appendXWWWFormURLEncodedValue(StringBuilder buf, String key, Object value) {
        UrlUtils.appendURLEncodedValue((Appendable)buf, (String)key, (Object)value);
    }

    protected String xWWWFormURLEncoded(Map<String, ?> data) {
        return UrlUtils.urlEncoded(data);
    }

    protected URLConnection postXWWWFormURLEncodedData(String url, String accept, Map<String, ?> data) throws IOException {
        return UrlUtils.postXWWWFormURLEncodedData((Logger)this.log, (String)url, (String)accept, data, (int)this.connectionTimeout, (SSLService)((SSLService)OptionalService.service(this.sslService)));
    }

    protected String postXWWWFormURLEncodedDataForString(String url, Map<String, ?> data) throws IOException {
        URLConnection conn = this.postXWWWFormURLEncodedData(url, "text/*, application/json", data);
        return FileCopyUtils.copyToString((Reader)this.getUnicodeReaderFromURLConnection(conn));
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public OptionalService<SSLService> getSslService() {
        return this.sslService;
    }

    public void setSslService(OptionalService<SSLService> sslService) {
        this.sslService = sslService;
    }
}

