/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.zip.GZIPOutputStream;
import net.solarnetwork.node.service.support.HttpClientSupport;
import net.solarnetwork.service.RemoteServiceException;

public abstract class JsonHttpClientSupport
extends HttpClientSupport {
    public static final String JSON_MIME_TYPE = "application/json";
    private ObjectMapper objectMapper;
    private boolean compress = false;

    protected final InputStream doJson(String url, String method, Object data) throws IOException {
        return this.doJson(url, method, data, null);
    }

    protected final InputStream doJson(String url, String method, Object data, Consumer<URLConnection> connectionCustomizer) throws IOException {
        URLConnection conn = this.getURLConnection(url, method, JSON_MIME_TYPE, connectionCustomizer);
        if (data != null) {
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            if (this.compress) {
                conn.setRequestProperty("Content-Encoding", "gzip");
            }
            OutputStream out = conn.getOutputStream();
            if (this.compress) {
                out = new GZIPOutputStream(out);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Posting JSON data: {}", (Object)this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(data));
            }
            this.objectMapper.writeValue(out, data);
            out.flush();
            out.close();
        }
        return this.getInputStreamFromURLConnection(conn);
    }

    protected final InputStream jsonGET(String url) throws IOException {
        return this.doJson(url, "GET", null, null);
    }

    protected final InputStream jsonGET(String url, Consumer<URLConnection> connectionCustomizer) throws IOException {
        return this.doJson(url, "GET", null, connectionCustomizer);
    }

    protected final InputStream jsonPOST(String url, Object data) throws IOException {
        return this.doJson(url, "POST", data);
    }

    protected final InputStream jsonPOST(String url, Object data, Consumer<URLConnection> connectionCustomizer) throws IOException {
        return this.doJson(url, "POST", data, connectionCustomizer);
    }

    protected <T> T extractResponseData(InputStream in, Class<T> dataType) throws RemoteServiceException, IOException {
        ObjectMapper mapper = this.getObjectMapper();
        if (mapper == null) {
            throw new RuntimeException("No ObjectMapper configured for extracting JSON response data with.");
        }
        try {
            JsonNode child;
            JsonNode root = mapper.readTree(in);
            if (root.isObject() && (child = root.get("success")) != null && child.asBoolean()) {
                child = root.get("data");
                if (child != null) {
                    Object object = this.objectMapper.treeToValue((TreeNode)child, dataType);
                    return (T)object;
                }
                this.log.debug("Server returned no data for request.");
                T t = null;
                return t;
            }
            throw new RemoteServiceException("Server response not successful: " + (root.get("message") == null ? "(no message)" : root.get("message").asText()));
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected <T> Collection<T> extractCollectionResponseData(InputStream in, Class<T> dataType) throws RemoteServiceException, IOException {
        try {
            JsonNode child;
            JsonNode root = this.getObjectMapper().readTree(in);
            if (root.isObject() && (child = root.get("success")) != null && child.asBoolean()) {
                child = root.get("data");
                if (child != null && child.isArray()) {
                    Iterator children = child.iterator();
                    ArrayList<Object> result = new ArrayList<Object>();
                    while (children.hasNext()) {
                        child = (JsonNode)children.next();
                        result.add(this.objectMapper.treeToValue((TreeNode)child, dataType));
                    }
                    ArrayList<Object> arrayList = result;
                    return arrayList;
                }
                this.log.debug("Server returned no data for request.");
                Collection<T> collection = null;
                return collection;
            }
            throw new RemoteServiceException("Server response not successful: " + root.get("message") == null ? "(no message)" : root.get("message").asText());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected <T> Collection<T> extractFilterResultsCollectionResponseData(InputStream in, Class<T> dataType) throws RemoteServiceException, IOException {
        try {
            JsonNode child;
            JsonNode root = this.getObjectMapper().readTree(in);
            if (root.isObject() && (child = root.get("success")) != null && child.asBoolean()) {
                child = root.get("data");
                if (child != null) {
                    child = child.get("results");
                }
                if (child != null && child.isArray()) {
                    Iterator children = child.iterator();
                    ArrayList<Object> result = new ArrayList<Object>();
                    while (children.hasNext()) {
                        child = (JsonNode)children.next();
                        result.add(this.objectMapper.treeToValue((TreeNode)child, dataType));
                    }
                    ArrayList<Object> arrayList = result;
                    return arrayList;
                }
                this.log.debug("Server returned no data for request.");
                Collection<T> collection = null;
                return collection;
            }
            throw new RemoteServiceException("Server response not successful: " + root.get("message") == null ? "(no message)" : root.get("message").asText());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected void verifyResponseSuccess(InputStream in) throws RemoteServiceException, IOException {
        try {
            JsonNode child;
            JsonNode root = this.getObjectMapper().readTree(in);
            if (root.isObject() && (child = root.get("success")) != null && child.asBoolean()) {
                return;
            }
            throw new RemoteServiceException("Server response not successful: " + root.get("message") == null ? "(no message)" : root.get("message").asText());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public final void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public final boolean isCompress() {
        return this.compress;
    }

    public final void setCompress(boolean compress) {
        this.compress = compress;
    }
}

