/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.service.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.solarnetwork.node.service.PlatformPackageService;
import net.solarnetwork.node.service.support.BasePlatformPackageService;
import net.solarnetwork.node.service.support.BasicPlatformPackageResult;
import net.solarnetwork.service.ProgressListener;

public class NativeTarPlatformPackageService
extends BasePlatformPackageService {
    public static final String SOURCE_FILE_PLACEHOLDER = "__SOURCE_FILE__";
    public static final String DESTINATION_DIRECTORY_PLACEHOLDER = "__DEST_DIR__";
    public static final List<String> DEFAULT_TAR_COMMAND = Collections.unmodifiableList(Arrays.asList("tar", "xvf", "__SOURCE_FILE__", "-C", "__DEST_DIR__"));
    private static final Pattern TARBALL_PAT = Pattern.compile("\\.(tar|tgz|tbz2|txz)$");
    private static final Pattern TAR_LIST_PAT = Pattern.compile("^\\w (.*)$");
    private List<String> tarCommand = DEFAULT_TAR_COMMAND;

    @Override
    public boolean handlesPackage(String archiveFileName) {
        return archiveFileName != null && TARBALL_PAT.matcher(archiveFileName).find();
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> installPackage(Path archive, Path baseDirectory, ProgressListener<T> progressListener, T context) {
        return this.performPackageResultTask(this.createTask(archive, baseDirectory, progressListener, context), context);
    }

    protected <T> Callable<PlatformPackageService.PlatformPackageResult<T>> createTask(final Path archive, final Path baseDirectory, ProgressListener<T> progressListener, final T context) {
        return new Callable<PlatformPackageService.PlatformPackageResult<T>>(){

            @Override
            public PlatformPackageService.PlatformPackageResult<T> call() throws Exception {
                ArrayList<String> cmd = new ArrayList<String>(NativeTarPlatformPackageService.this.tarCommand.size());
                String tarballPath = archive.toAbsolutePath().toString();
                for (Object param : NativeTarPlatformPackageService.this.tarCommand) {
                    param = ((String)param).replace(NativeTarPlatformPackageService.SOURCE_FILE_PLACEHOLDER, tarballPath);
                    param = ((String)param).replace(NativeTarPlatformPackageService.DESTINATION_DIRECTORY_PLACEHOLDER, baseDirectory.toString());
                    cmd.add((String)param);
                }
                if (NativeTarPlatformPackageService.this.log.isDebugEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    for (String p2 : cmd) {
                        if (buf.length() > 0) {
                            buf.append(' ');
                        }
                        buf.append(p2);
                    }
                    NativeTarPlatformPackageService.this.log.debug("Tar command: {}", (Object)buf.toString());
                }
                NativeTarPlatformPackageService.this.log.info("Extracting tar archive {}", (Object)archive);
                ArrayList<Path> extractedPaths = new ArrayList<Path>();
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.redirectErrorStream(true);
                Process pr = pb.start();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));){
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        Matcher m = TAR_LIST_PAT.matcher(line);
                        if (m.matches()) {
                            line = m.group(1);
                        }
                        Path path = FileSystems.getDefault().getPath(line, new String[0]).toAbsolutePath().normalize();
                        extractedPaths.add(path);
                        NativeTarPlatformPackageService.this.log.trace("Installed setup resource: {}", (Object)line);
                    }
                }
                try {
                    pr.waitFor();
                }
                catch (InterruptedException e) {
                    NativeTarPlatformPackageService.this.log.warn("Interrupted waiting for tar command to complete");
                }
                if (pr.exitValue() != 0) {
                    String output = extractedPaths.stream().map(p -> p.toString()).collect(Collectors.joining("\n")).trim();
                    NativeTarPlatformPackageService.this.log.error("Tar command returned non-zero exit code {}: {}", (Object)pr.exitValue(), (Object)output);
                    throw new IOException("Tar command returned non-zero exit code " + pr.exitValue() + ": " + output);
                }
                return new BasicPlatformPackageResult<Object>(true, null, null, extractedPaths, context);
            }
        };
    }

    @Override
    public Future<Iterable<PlatformPackageService.PlatformPackage>> listNamedPackages(String nameFilter, Boolean installedFilter) {
        CompletableFuture<Iterable<PlatformPackageService.PlatformPackage>> f = new CompletableFuture<Iterable<PlatformPackageService.PlatformPackage>>();
        f.complete(Collections.emptyList());
        return f;
    }

    @Override
    public Future<Iterable<PlatformPackageService.PlatformPackage>> listUpgradableNamedPackages() {
        CompletableFuture<Iterable<PlatformPackageService.PlatformPackage>> f = new CompletableFuture<Iterable<PlatformPackageService.PlatformPackage>>();
        f.complete(Collections.emptyList());
        return f;
    }

    @Override
    public Future<Boolean> refreshNamedPackages() {
        CompletableFuture<Boolean> f = new CompletableFuture<Boolean>();
        f.complete(true);
        return f;
    }

    @Override
    public Future<Boolean> cleanup() {
        CompletableFuture<Boolean> f = new CompletableFuture<Boolean>();
        f.complete(true);
        return f;
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> installNamedPackage(String name, String version, Path baseDirectory, ProgressListener<T> progressListener, T context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> removeNamedPackage(String name, ProgressListener<T> progressListener, T context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<PlatformPackageService.PlatformPackageResult<T>> upgradeNamedPackages(ProgressListener<T> progressListener, T context) {
        throw new UnsupportedOperationException();
    }

    public void setTarCommand(List<String> tarCommand) {
        this.tarCommand = tarCommand;
    }
}

