/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.settings.support;

import java.util.Set;
import net.solarnetwork.node.settings.FileSettingSpecifier;
import net.solarnetwork.settings.MappableSpecifier;
import net.solarnetwork.settings.SettingSpecifier;
import net.solarnetwork.settings.support.BaseKeyedSettingSpecifier;
import org.springframework.core.io.Resource;

public class BasicFileSettingSpecifier
extends BaseKeyedSettingSpecifier<Resource>
implements FileSettingSpecifier {
    private final Set<String> acceptableFileTypeSpecifiers;
    private final boolean multiple;

    public BasicFileSettingSpecifier(String key, Resource defaultValue) {
        this(key, defaultValue, null, false);
    }

    public BasicFileSettingSpecifier(String key, Resource defaultValue, Set<String> acceptableFileTypeSpecifiers, boolean multiple) {
        super(key, (Object)defaultValue);
        this.acceptableFileTypeSpecifiers = acceptableFileTypeSpecifiers;
        this.multiple = multiple;
    }

    public SettingSpecifier mappedWithPlaceholer(String template) {
        BasicFileSettingSpecifier spec = new BasicFileSettingSpecifier(String.format(template, this.getKey()), (Resource)this.getDefaultValue(), this.getAcceptableFileTypeSpecifiers(), this.isMultiple());
        spec.setTitle(this.getTitle());
        spec.setDescriptionArguments(this.getDescriptionArguments());
        return spec;
    }

    public SettingSpecifier mappedWithMapper(MappableSpecifier.Mapper mapper) {
        BasicFileSettingSpecifier spec = new BasicFileSettingSpecifier(mapper.mapKey(this.getKey()), (Resource)this.getDefaultValue(), this.getAcceptableFileTypeSpecifiers(), this.isMultiple());
        spec.setTitle(this.getTitle());
        spec.setDescriptionArguments(this.getDescriptionArguments());
        return spec;
    }

    @Override
    public Set<String> getAcceptableFileTypeSpecifiers() {
        return this.acceptableFileTypeSpecifiers;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }
}

