/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.setup;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.solarnetwork.node.setup.SetupResource;
import net.solarnetwork.node.setup.SetupResourceScope;
import org.springframework.core.io.Resource;

public abstract class BaseStaticSetupResource
implements SetupResource {
    private final String uid;
    private final String contentType;
    private final int cacheSeconds;
    private final Set<String> consumerTypes;
    private final Set<String> roles;
    private final long contentLength;
    private final long lastModified;
    private final Locale locale;
    private final SetupResourceScope scope;

    public BaseStaticSetupResource(String uid, String contentType, Set<String> consumerTypes, Set<String> roles) {
        this(uid, contentType, null, -1, -1L, -1L, roles, consumerTypes);
    }

    public BaseStaticSetupResource(String uid, String contentType, Locale locale, int cacheSeconds, Set<String> roles, Set<String> consumerTypes, Resource resource) throws IOException {
        this(uid, contentType, locale, cacheSeconds, resource.contentLength(), resource.lastModified(), roles, consumerTypes);
    }

    public BaseStaticSetupResource(String uid, String contentType, Locale locale, int cacheSeconds, Set<String> roles, Set<String> consumerTypes, Resource resource, SetupResourceScope scope) throws IOException {
        this(uid, contentType, locale, cacheSeconds, resource.contentLength(), resource.lastModified(), roles, consumerTypes, scope);
    }

    public BaseStaticSetupResource(String uid, String contentType, Locale locale, int cacheSeconds, long contentLength, long lastModified, Set<String> consumerTypes, Set<String> roles) {
        this(uid, contentType, locale, cacheSeconds, contentLength, lastModified, consumerTypes, roles, null);
    }

    public BaseStaticSetupResource(String uid, String contentType, Locale locale, int cacheSeconds, long contentLength, long lastModified, Set<String> consumerTypes, Set<String> roles, SetupResourceScope scope) {
        this.uid = uid;
        this.contentType = contentType;
        this.locale = locale;
        this.cacheSeconds = cacheSeconds;
        this.roles = roles;
        this.contentLength = contentLength;
        this.lastModified = lastModified;
        this.consumerTypes = consumerTypes;
        this.scope = scope;
    }

    @Override
    public String getResourceUID() {
        return this.uid;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Set<String> getRequiredRoles() {
        return this.roles;
    }

    @Override
    public int getCacheMaximumSeconds() {
        return this.cacheSeconds;
    }

    @Override
    public long contentLength() throws IOException {
        return this.contentLength;
    }

    @Override
    public long lastModified() throws IOException {
        return this.lastModified;
    }

    @Override
    public Set<String> getSupportedConsumerTypes() {
        return this.consumerTypes;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public SetupResourceScope getScope() {
        return this.scope;
    }
}

