/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.node.setup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Locale;
import net.solarnetwork.domain.SerializeIgnore;
import net.solarnetwork.node.setup.BundlePluginInfo;
import net.solarnetwork.node.setup.BundlePluginVersion;
import net.solarnetwork.node.setup.LocalizedPluginInfo;
import net.solarnetwork.node.setup.Plugin;
import net.solarnetwork.node.setup.PluginInfo;
import net.solarnetwork.node.setup.PluginVersion;
import org.osgi.framework.Bundle;

public class BundlePlugin
implements Plugin {
    private final Bundle bundle;
    private final BundlePluginVersion version;
    private final BundlePluginInfo info;
    private final boolean coreFeature;

    public BundlePlugin(Bundle bundle, boolean coreFeature) {
        this.bundle = bundle;
        this.coreFeature = coreFeature;
        this.version = new BundlePluginVersion(bundle.getVersion());
        this.info = new BundlePluginInfo(bundle);
    }

    @Override
    public String getUID() {
        return this.bundle.getSymbolicName();
    }

    @Override
    public PluginVersion getVersion() {
        return this.version;
    }

    @Override
    public PluginInfo getInfo() {
        return this.info;
    }

    @Override
    public PluginInfo getLocalizedInfo(Locale locale) {
        return new LocalizedPluginInfo(this.info, locale);
    }

    @Override
    public boolean isCoreFeature() {
        return this.coreFeature;
    }

    @JsonIgnore
    @SerializeIgnore
    public Bundle getBundle() {
        return this.bundle;
    }
}

