/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.agent;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgentOptions {
    private static final Logger log = LoggerFactory.getLogger(AgentOptions.class);
    private int clusterInstances = 1;
    private final AtomicInteger clusterInstancesCache = new AtomicInteger(this.clusterInstances);
    private IntSupplier clusterInstancesResolver;
    private int maxInstancesOnNode = 4;
    private boolean isHA = false;
    private OnCompleteAction onCompleteAction = OnCompleteAction.undeploy;
    private AgentRestartStrategy onCompleteRestartStrategy = AlwaysRestart.INSTANCE;
    private AgentRestartStrategy agentRestartStrategy = AlwaysRestart.INSTANCE;

    public boolean isHA() {
        return this.isHA;
    }

    public AgentOptions setHA(boolean value) {
        this.isHA = value;
        return this;
    }

    public int getClusterInstances() {
        if (this.clusterInstancesResolver == null) {
            return this.clusterInstances;
        }
        try {
            int instances = this.clusterInstancesResolver.getAsInt();
            if (instances != this.clusterInstancesCache.get()) {
                this.clusterInstancesCache.set(instances);
            }
            return instances;
        }
        catch (Exception e) {
            log.warn("Unable to resolve cluster instances, using default value: {}", (Object)this.clusterInstancesCache.get(), (Object)e);
            return this.clusterInstancesCache.get();
        }
    }

    public AgentOptions setClusterInstances(int clusterInstances) {
        if (clusterInstances < 1) {
            throw new IllegalArgumentException("Cluster instances cannot be less than 1 but was " + clusterInstances);
        }
        this.clusterInstances = clusterInstances;
        return this;
    }

    public AgentOptions setClusterInstances(IntSupplier clusterInstancesResolver) {
        this.clusterInstancesResolver = clusterInstancesResolver;
        return this;
    }

    public OnCompleteAction getOnCompleteAction() {
        return this.onCompleteAction;
    }

    public AgentOptions setOnCompleteAction(OnCompleteAction onCompleteAction) {
        this.onCompleteAction = onCompleteAction;
        return this;
    }

    public int getMaxInstancesOnNode() {
        return this.maxInstancesOnNode;
    }

    public AgentOptions setMaxInstancesOnNode(int maxInstancesOnNode) {
        this.maxInstancesOnNode = maxInstancesOnNode;
        return this;
    }

    public AgentRestartStrategy getOnCompleteRestartStrategy() {
        return this.onCompleteRestartStrategy;
    }

    public AgentOptions setOnCompleteRestartStrategy(AgentRestartStrategy onCompleteRestartStrategy) {
        this.onCompleteRestartStrategy = onCompleteRestartStrategy;
        return this;
    }

    public AgentRestartStrategy getAgentRestartStrategy() {
        return this.agentRestartStrategy;
    }

    public AgentOptions setAgentRestartStrategy(AgentRestartStrategy agentRestartStrategy) {
        this.agentRestartStrategy = agentRestartStrategy;
        return this;
    }

    public static final class RestartWithTimeout
    implements AgentRestartStrategy {
        private final Duration timeout;

        public RestartWithTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public static RestartWithTimeout of(Duration timeout) {
            return new RestartWithTimeout(timeout);
        }

        @Override
        public boolean restart(Runnable agentRunner) {
            try {
                Thread.sleep(this.timeout.toMillis());
                agentRunner.run();
                return true;
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RestartWithTimeout)) {
                return false;
            }
            RestartWithTimeout that = (RestartWithTimeout)o;
            return Objects.equals(this.timeout, that.timeout);
        }

        public int hashCode() {
            return Objects.hash(this.timeout);
        }
    }

    public static final class RestartTimes
    implements AgentRestartStrategy {
        public final int times;
        private int timesRestarted = 0;

        public RestartTimes(int times) {
            this.times = times;
        }

        public RestartTimes of(int noOfTimes) {
            return new RestartTimes(noOfTimes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RestartTimes)) {
                return false;
            }
            RestartTimes that = (RestartTimes)o;
            return this.times == that.times;
        }

        public int hashCode() {
            return Objects.hash(this.times);
        }

        @Override
        public boolean restart(Runnable agentRunner) {
            if (this.timesRestarted++ < this.times) {
                agentRunner.run();
                return true;
            }
            return false;
        }
    }

    public static final class NeverRestart
    implements AgentRestartStrategy {
        public static final AgentRestartStrategy INSTANCE = new RestartTimes(0);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof NeverRestart;
        }

        @Override
        public boolean restart(Runnable agentRunner) {
            return false;
        }
    }

    public static final class AlwaysRestart
    implements AgentRestartStrategy {
        public static final AlwaysRestart INSTANCE = new AlwaysRestart();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof AlwaysRestart;
        }

        @Override
        public boolean restart(Runnable agentRunner) {
            agentRunner.run();
            return true;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    public static interface AgentRestartStrategy {
        public boolean restart(Runnable var1);
    }

    public static enum OnCompleteAction {
        undeploy,
        restart;

    }
}

