/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.client.commands;

import io.reactivex.Flowable;
import java.util.List;
import java.util.Objects;
import net.soundvibe.reacto.client.commands.CommandExecutor;
import net.soundvibe.reacto.client.commands.CommandExecutorFactory;
import net.soundvibe.reacto.client.events.CommandHandler;
import net.soundvibe.reacto.discovery.LoadBalancer;
import net.soundvibe.reacto.errors.CannotFindEventHandlers;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.Event;

public final class ReactoCommandExecutor
implements CommandExecutor {
    private final List<CommandHandler> commandHandlers;
    private final LoadBalancer<CommandHandler> loadBalancer;
    public static final CommandExecutorFactory FACTORY = ReactoCommandExecutor::new;

    public ReactoCommandExecutor(List<CommandHandler> commandHandlers, LoadBalancer<CommandHandler> loadBalancer) {
        Objects.requireNonNull(commandHandlers, "commandHandlers cannot be null");
        Objects.requireNonNull(loadBalancer, "loadBalancer cannot be null");
        this.commandHandlers = commandHandlers;
        this.loadBalancer = loadBalancer;
    }

    @Override
    public Flowable<Event> execute(Command command) {
        if (this.commandHandlers.isEmpty()) {
            return Flowable.error((Throwable)new CannotFindEventHandlers("No command handlers found for command: " + command));
        }
        return Flowable.just(this.commandHandlers).map(this.loadBalancer::balance).concatMap(eventHandler -> eventHandler.observe(command).onErrorResumeNext(error -> this.handleError((Throwable)error, command, (CommandHandler)eventHandler)));
    }

    private Flowable<Event> handleError(Throwable error, Command command, CommandHandler commandHandler) {
        return Flowable.just((Object)commandHandler).doOnNext(this::removeHandler).flatMap(any -> this.commandHandlers.isEmpty() ? Flowable.error((Throwable)error) : Flowable.just((Object)command)).flatMap(this::execute);
    }

    private synchronized void removeHandler(CommandHandler commandHandler) {
        this.commandHandlers.remove(commandHandler);
    }
}

