/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.client.events;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.soundvibe.reacto.client.events.CommandHandler;
import net.soundvibe.reacto.client.events.CommandHandlerFactory;
import net.soundvibe.reacto.discovery.types.ServiceRecord;
import net.soundvibe.reacto.discovery.types.ServiceType;

public final class CommandHandlerRegistry {
    private final Map<ServiceType, CommandHandlerFactory> handlers;
    private final Map<ServiceRecord, CommandHandler> cache;
    private static final CommandHandlerRegistry EMPTY = new CommandHandlerRegistry(Collections.emptyMap());

    public static CommandHandlerRegistry empty() {
        return EMPTY;
    }

    private CommandHandlerRegistry(Map<ServiceType, CommandHandlerFactory> handlers) {
        this.handlers = handlers;
        this.cache = new ConcurrentHashMap<ServiceRecord, CommandHandler>(handlers.size());
    }

    public Optional<CommandHandlerFactory> findFactory(ServiceType serviceType) {
        return Optional.ofNullable(this.handlers.get((Object)serviceType));
    }

    public Stream<CommandHandler> find(ServiceRecord serviceRecord) {
        return this.findFactory(serviceRecord.type).map(factory -> Stream.of(this.cache.computeIfAbsent(serviceRecord, factory::create))).orElseGet(Stream::empty);
    }

    public static final class Builder {
        private final Map<ServiceType, CommandHandlerFactory> handlers = new EnumMap<ServiceType, CommandHandlerFactory>(ServiceType.class);

        public static Builder create() {
            return new Builder();
        }

        public Builder register(ServiceType serviceType, CommandHandlerFactory commandHandlerFactory) {
            this.handlers.put(serviceType, commandHandlerFactory);
            return this;
        }

        public CommandHandlerRegistry build() {
            return new CommandHandlerRegistry(this.handlers);
        }
    }
}

