/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.client.events;

import io.reactivex.Flowable;
import java.util.Objects;
import net.soundvibe.reacto.client.events.CommandHandler;
import net.soundvibe.reacto.discovery.types.ServiceRecord;
import net.soundvibe.reacto.errors.CannotDiscoverService;
import net.soundvibe.reacto.server.CommandRegistry;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.CommandDescriptor;
import net.soundvibe.reacto.types.Event;

public final class LocalCommandHandler
implements CommandHandler {
    private final ServiceRecord serviceRecord;
    private final CommandRegistry commandRegistry;

    public LocalCommandHandler(ServiceRecord serviceRecord, CommandRegistry commandRegistry) {
        Objects.requireNonNull(serviceRecord, "serviceRecord cannot be null");
        Objects.requireNonNull(commandRegistry, "commandRegistry cannot be null");
        this.serviceRecord = serviceRecord;
        this.commandRegistry = commandRegistry;
    }

    @Override
    public Flowable<Event> observe(Command command) {
        return this.commandRegistry.findCommand(CommandDescriptor.fromCommand(command)).map(commandExecutor -> commandExecutor.execute(command)).orElseGet(() -> Flowable.error((Throwable)new CannotDiscoverService("Unable to find service for " + command)));
    }

    @Override
    public ServiceRecord serviceRecord() {
        return this.serviceRecord;
    }
}

