/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.discovery;

import com.codahale.metrics.Timer;
import io.reactivex.Flowable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.soundvibe.reacto.client.commands.CommandExecutor;
import net.soundvibe.reacto.client.commands.CommandExecutorFactory;
import net.soundvibe.reacto.client.events.CommandHandler;
import net.soundvibe.reacto.client.events.CommandHandlerRegistry;
import net.soundvibe.reacto.discovery.LoadBalancer;
import net.soundvibe.reacto.discovery.ServiceRegistry;
import net.soundvibe.reacto.discovery.types.ServiceRecord;
import net.soundvibe.reacto.errors.CannotDiscoverService;
import net.soundvibe.reacto.errors.CannotFindEventHandlers;
import net.soundvibe.reacto.internal.Cache;
import net.soundvibe.reacto.internal.ExpiringCache;
import net.soundvibe.reacto.mappers.ServiceRegistryMapper;
import net.soundvibe.reacto.metric.ObserverMetric;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.Event;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    private final ServiceRegistryMapper mapper;
    private final CommandHandlerRegistry commandHandlerRegistry;
    private final Cache<String, Flowable<List<ServiceRecord>>> commandCache = ExpiringCache.periodically(10L, TimeUnit.SECONDS);

    protected AbstractServiceRegistry(CommandHandlerRegistry commandHandlerRegistry, ServiceRegistryMapper mapper) {
        Objects.requireNonNull(mapper, "mapper cannot be null");
        Objects.requireNonNull(commandHandlerRegistry, "commandHandlerRegistry cannot be null");
        this.commandHandlerRegistry = commandHandlerRegistry;
        this.mapper = mapper;
    }

    protected Flowable<Event> execute(Command command, LoadBalancer<CommandHandler> loadBalancer, CommandExecutorFactory commandExecutorFactory) {
        return Flowable.fromCallable(() -> ObserverMetric.findObserver(command)).flatMap(metric -> Flowable.using(metric::startTimer, pair -> this.commandCache.computeIfAbsent(this.commandKey(command), key -> this.findRecordsOf(command).cache()).compose(records -> this.findExecutor((Flowable<List<ServiceRecord>>)records, command.name, loadBalancer, commandExecutorFactory)).concatMap(commandExecutor -> commandExecutor.execute(command)).doOnEach((Subscriber)pair.key), pair -> ((Timer.Context)pair.value).stop()));
    }

    protected abstract Flowable<List<ServiceRecord>> findRecordsOf(Command var1);

    private String commandKey(Command command) {
        return command.name + ":" + command.eventType();
    }

    Flowable<CommandExecutor> findExecutor(Flowable<List<ServiceRecord>> records, String name, LoadBalancer<CommandHandler> loadBalancer, CommandExecutorFactory commandExecutorFactory) {
        return records.filter(recs -> !recs.isEmpty()).switchIfEmpty((Publisher)Flowable.defer(() -> Flowable.error((Throwable)new CannotDiscoverService("Unable to discover any of " + name)))).flatMap(recs -> Flowable.just(recs.stream().flatMap(this.commandHandlerRegistry::find).collect(Collectors.toList())).flatMap(eventHandlers -> eventHandlers.isEmpty() ? Flowable.error((Throwable)new CannotFindEventHandlers("Unable to find at least one compatible event handler for " + recs)) : Flowable.just((Object)eventHandlers))).map(eventHandlers -> commandExecutorFactory.create((List<CommandHandler>)eventHandlers, loadBalancer));
    }

    @Override
    public <E, C> Flowable<E> execute(C command, Class<? extends E> eventClass, LoadBalancer<CommandHandler> loadBalancer, CommandExecutorFactory commandExecutorFactory) {
        if (command == null) {
            return Flowable.error((Throwable)new IllegalArgumentException("command cannot be null"));
        }
        if (eventClass == null) {
            return Flowable.error((Throwable)new IllegalArgumentException("eventClass cannot be null"));
        }
        if (loadBalancer == null) {
            return Flowable.error((Throwable)new IllegalArgumentException("loadBalancer cannot be null"));
        }
        if (command instanceof Command && eventClass.isAssignableFrom(Event.class)) {
            return this.execute((Command)command, loadBalancer, commandExecutorFactory);
        }
        return Flowable.just(command).map(cmd -> this.mapper.toCommand(cmd, eventClass)).concatMap(typedCommand -> this.execute((Command)typedCommand, loadBalancer, commandExecutorFactory)).map(event -> this.mapper.toGenericEvent((Event)event, eventClass));
    }
}

