/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.discovery;

import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.soundvibe.reacto.client.events.CommandHandlerRegistry;
import net.soundvibe.reacto.client.events.LocalCommandHandler;
import net.soundvibe.reacto.discovery.AbstractServiceRegistry;
import net.soundvibe.reacto.discovery.types.ServiceRecord;
import net.soundvibe.reacto.discovery.types.ServiceType;
import net.soundvibe.reacto.discovery.types.Status;
import net.soundvibe.reacto.internal.ObjectId;
import net.soundvibe.reacto.mappers.ServiceRegistryMapper;
import net.soundvibe.reacto.server.CommandRegistry;
import net.soundvibe.reacto.types.Any;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.CommandDescriptor;
import net.soundvibe.reacto.types.json.JsonObject;

public final class LocalServiceRegistry
extends AbstractServiceRegistry {
    private final CommandRegistry commandRegistry;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);

    public LocalServiceRegistry(ServiceRegistryMapper mapper, CommandRegistry commandRegistry) {
        super(CommandHandlerRegistry.Builder.create().register(ServiceType.LOCAL, serviceRecord -> new LocalCommandHandler(serviceRecord, commandRegistry)).build(), mapper);
        this.commandRegistry = commandRegistry;
    }

    @Override
    public Flowable<Any> register() {
        return Flowable.just((Object)this.isClosed).filter(AtomicBoolean::get).doOnNext(closed -> closed.set(false)).map(__ -> Any.VOID);
    }

    @Override
    public Flowable<Any> unregister() {
        return Flowable.just((Object)this.isClosed).filter(closed -> !closed.get()).doOnNext(closed -> closed.set(true)).map(__ -> Any.VOID);
    }

    @Override
    protected Flowable<List<ServiceRecord>> findRecordsOf(Command command) {
        return this.commandRegistry.findCommand(CommandDescriptor.fromCommand(command)).isPresent() ? Flowable.just(Collections.singletonList(this.createRecord())) : Flowable.empty();
    }

    private ServiceRecord createRecord() {
        return ServiceRecord.create("local-service", Status.UP, ServiceType.LOCAL, ObjectId.get().toString(), JsonObject.empty(), JsonObject.empty());
    }
}

