/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.discovery;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.soundvibe.reacto.discovery.LoadBalancer;
import net.soundvibe.reacto.types.Named;

public final class RoundRobinLoadBalancer<T extends Named>
implements LoadBalancer<T> {
    private final ConcurrentHashMap<String, Integer> cachedRecords = new ConcurrentHashMap();

    @Override
    public T balance(List<T> records) {
        if (records.isEmpty()) {
            throw new IllegalArgumentException("No elements to balance");
        }
        return (T)((Named)records.get(this.cachedRecords.compute(((Named)records.get(0)).name(), (name, lastIndex) -> {
            if (lastIndex == null) {
                return 0;
            }
            int newIndex = lastIndex + 1;
            return newIndex >= records.size() ? 0 : newIndex;
        })));
    }
}

