/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.discovery.types;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import net.soundvibe.reacto.discovery.types.ServiceType;
import net.soundvibe.reacto.discovery.types.Status;
import net.soundvibe.reacto.internal.ObjectId;
import net.soundvibe.reacto.mappers.jackson.JacksonMapper;
import net.soundvibe.reacto.server.CommandRegistry;
import net.soundvibe.reacto.server.ServiceOptions;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.CommandDescriptor;
import net.soundvibe.reacto.types.json.JsonObject;
import net.soundvibe.reacto.types.json.JsonObjectBuilder;
import net.soundvibe.reacto.utils.WebUtils;

public final class ServiceRecord {
    public static final String LOCATION_HOST = "host";
    public static final String LOCATION_PORT = "port";
    public static final String LOCATION_ROOT = "root";
    public static final String LOCATION_SSL = "ssl";
    public static final String METADATA_VERSION = "version";
    public static final String METADATA_COMMANDS = "commands";
    public final String name;
    public final Status status;
    public final ServiceType type;
    public final String registrationId;
    public final JsonObject location;
    public final JsonObject metadata;
    public final String objectType = "reacto-service-registry";
    private int hash = 0;

    private ServiceRecord(String name, Status status, ServiceType type, String registrationId, JsonObject location, JsonObject metadata) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(status, "status cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        Objects.requireNonNull(registrationId, "registrationId cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        Objects.requireNonNull(metadata, "metadata cannot be null");
        this.name = name;
        this.status = status;
        this.type = type;
        this.registrationId = registrationId;
        this.location = location;
        this.metadata = metadata;
    }

    public static ServiceRecord fromJson(String json) {
        return JacksonMapper.fromJson(json, ServiceRecord.class);
    }

    public static ServiceRecord createWebSocketEndpoint(ServiceOptions serviceOptions, CommandRegistry commandsToRegister) {
        return ServiceRecord.createWebSocketEndpoint(serviceOptions, commandsToRegister.streamOfKeys().collect(Collectors.toList()));
    }

    public static ServiceRecord createWebSocketEndpoint(ServiceOptions serviceOptions, Collection<CommandDescriptor> commandsToRegister) {
        return ServiceRecord.create(WebUtils.excludeEndDelimiter(WebUtils.excludeStartDelimiter(serviceOptions.serviceName)), Status.UP, ServiceType.WEBSOCKET, ObjectId.get().toString(), ServiceRecord.httpEndpointLocation(WebUtils.getLocalAddress(), serviceOptions.port, WebUtils.includeEndDelimiter(WebUtils.includeStartDelimiter(serviceOptions.root)), serviceOptions.isSsl), JsonObjectBuilder.create().put(METADATA_VERSION, serviceOptions.version).putArray(METADATA_COMMANDS, arrayBuilder -> {
            commandsToRegister.stream().map(commandDescriptor -> JsonObjectBuilder.create().put("commandType", commandDescriptor.commandType).put("eventType", commandDescriptor.eventType).build()).forEach(arrayBuilder::add);
            return arrayBuilder;
        }).build());
    }

    public static ServiceRecord create(String name, Status status, ServiceType type, String registrationId, JsonObject location, JsonObject metaData) {
        return new ServiceRecord(name, status, type, registrationId, location, metaData);
    }

    private static JsonObject httpEndpointLocation(String host, int port, String root, boolean isSsl) {
        return JsonObjectBuilder.create().put(LOCATION_HOST, host).put(LOCATION_PORT, port).put(LOCATION_ROOT, root).put(LOCATION_SSL, isSsl).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceRecord that = (ServiceRecord)o;
        return Objects.equals(this.name, that.name) && this.status == that.status && this.type == that.type && Objects.equals(this.registrationId, that.registrationId) && Objects.equals(this.location, that.location) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(new Object[]{this.name, this.status, this.type, this.registrationId, this.location, this.metadata});
        }
        return this.hash;
    }

    public String toString() {
        return "ServiceRecord{name='" + this.name + '\'' + ", status=" + (Object)((Object)this.status) + ", type=" + (Object)((Object)this.type) + ", registrationId='" + this.registrationId + '\'' + ", location=" + this.location + ", metadata=" + this.metadata + '}';
    }

    public boolean isCompatibleWith(Command command) {
        return this.status == Status.UP && this.metadata.asArray(METADATA_COMMANDS).map(commands -> commands.stream().filter(o -> o instanceof JsonObject).map(o -> (JsonObject)o).anyMatch(jsonObject -> command.name.equals(jsonObject.asString("commandType").orElse(null)) && command.eventType().equals(jsonObject.asString("eventType").orElse(null)))).orElse(false) != false;
    }

    public String toJson() {
        return JacksonMapper.toJson(this);
    }
}

