/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.errors;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.function.Consumer;
import net.soundvibe.reacto.utils.Exceptions;

public class ReactiveException
extends RuntimeException {
    public final String className;
    public final String message;
    public final String stackTrace;

    public ReactiveException(String className, String message, String stackTrace) {
        super(message);
        this.className = className;
        this.message = message;
        this.stackTrace = stackTrace;
    }

    public static ReactiveException from(Throwable throwable) {
        return new ReactiveException(throwable.getClass().getName(), throwable.getMessage() == null ? throwable.toString() : throwable.getMessage(), Exceptions.getStackTrace(throwable));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(s::println);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(s::println);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReactiveException that = (ReactiveException)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.message, that.message) && Objects.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.message, this.stackTrace);
    }

    private void printStackTrace(Consumer<String> printLnConsumer) {
        String[] lines;
        if (this.stackTrace == null) {
            return;
        }
        for (String line : lines = this.stackTrace.split("\\r?\\n")) {
            printLnConsumer.accept(line);
        }
    }

    @Override
    public String toString() {
        return "ReactiveException{className='" + this.className + '\'' + ", message='" + this.message + '\'' + ", stackTrace='" + this.stackTrace + '\'' + '}';
    }
}

