/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.soundvibe.reacto.internal.Cache;
import net.soundvibe.reacto.types.Pair;

public final class ExpiringCache<T, U>
implements Cache<T, U> {
    private final long durationInMs;
    private final Map<T, Pair<U, Long>> cache = new ConcurrentHashMap<T, Pair<U, Long>>();

    private ExpiringCache(long expireIn, TimeUnit timeUnit) {
        this.durationInMs = timeUnit.toMillis(expireIn);
    }

    public static <T, U> ExpiringCache<T, U> periodically(long expireIn, TimeUnit timeUnit) {
        return new ExpiringCache<T, U>(expireIn, timeUnit);
    }

    @Override
    public U computeIfAbsent(T key, Function<? super T, ? extends U> mappingFunction) {
        return (U)this.cache.compute(key, (k, v) -> v == null || System.currentTimeMillis() - (Long)v.value >= this.durationInMs ? Pair.of(mappingFunction.apply(k), System.currentTimeMillis()) : v).getKey();
    }
}

