/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.internal;

import java.util.Objects;
import java.util.function.Supplier;

public final class Lazy<T>
implements Supplier<T> {
    private final Object lock = new Object();
    private T value;
    private final Supplier<T> supplier;

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object object = this.lock;
        synchronized (object) {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lazy lazy = (Lazy)o;
        return Objects.equals(this.value, lazy.value);
    }

    public int hashCode() {
        return Objects.hash(this.get());
    }

    public String toString() {
        return "Lazy{value=" + this.value + '}';
    }
}

