/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.internal;

import com.google.protobuf.ByteString;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.soundvibe.reacto.errors.ReactiveException;
import net.soundvibe.reacto.internal.EventType;
import net.soundvibe.reacto.internal.InternalEvent;
import net.soundvibe.reacto.internal.ObjectId;
import net.soundvibe.reacto.internal.proto.Messages;
import net.soundvibe.reacto.mappers.Mappers;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.MetaData;
import net.soundvibe.reacto.types.Pair;
import net.soundvibe.reacto.utils.Exceptions;

public interface MessageMappers {
    public static Command toCommand(Messages.Command protoBufCommand) {
        Stream<Pair<String, String>> pairStream = protoBufCommand.getMetadataList().stream().map(o -> Pair.of(o.getKey(), o.getValue()));
        return new Command(new ObjectId(protoBufCommand.getId()), protoBufCommand.getName(), protoBufCommand.getMetadataCount() == 0 ? Optional.empty() : Optional.of(MetaData.fromStream(pairStream)), protoBufCommand.getPayload().isEmpty() ? Optional.empty() : Optional.ofNullable(protoBufCommand.getPayload().toByteArray()));
    }

    public static InternalEvent toInternalEvent(Messages.Event protoBufEvent) {
        Stream<Pair<String, String>> pairStream = protoBufEvent.getMetadataList().stream().map(o -> Pair.of(o.getKey(), o.getValue()));
        EventType eventType = Optional.ofNullable(protoBufEvent.getEventType()).map(et -> EventType.valueOf(et.name())).orElse(EventType.ERROR);
        Optional<Throwable> error = eventType == EventType.ERROR ? MessageMappers.parseException(protoBufEvent) : Optional.empty();
        return new InternalEvent(protoBufEvent.getName(), protoBufEvent.getMetadataCount() == 0 ? Optional.empty() : Optional.of(MetaData.fromStream(pairStream)), protoBufEvent.getPayload().isEmpty() ? Optional.empty() : Optional.ofNullable(protoBufEvent.getPayload().toByteArray()), error, eventType);
    }

    public static Optional<Throwable> parseException(Messages.Event protoBufEvent) {
        Optional<Throwable> e;
        Optional<Throwable> optional = e = !protoBufEvent.getPayload().isEmpty() ? Mappers.fromBytesToException(protoBufEvent.getPayload().toByteArray()) : Optional.empty();
        if (!e.isPresent()) {
            return Optional.ofNullable(protoBufEvent.getError()).map(error -> new ReactiveException(error.getClassName(), error.getErrorMessage(), error.getStackTrace()));
        }
        return e;
    }

    public static Messages.Command toProtoBufCommand(Command command) {
        Messages.Command.Builder commandBuilder = Messages.Command.newBuilder();
        command.metaData.ifPresent(metaData -> {
            Messages.Metadata.Builder metaDataBuilder = Messages.Metadata.newBuilder();
            commandBuilder.addAllMetadata(metaData.stream().map(pair -> metaDataBuilder.setKey((String)pair.key).setValue((String)pair.value).build()).collect(Collectors.toList()));
        });
        command.payload.ifPresent(bytes -> commandBuilder.setPayload(ByteString.copyFrom((byte[])bytes)));
        return commandBuilder.setId(command.id.toString()).setName(command.name).build();
    }

    public static Messages.Event toProtoBufEvent(InternalEvent internalEvent) {
        Messages.Event.Builder eventBuilder = Messages.Event.newBuilder();
        eventBuilder.setName(internalEvent.name);
        eventBuilder.setEventType(Messages.EventType.valueOf(internalEvent.eventType.name()));
        internalEvent.error.ifPresent(e -> eventBuilder.setError(Messages.Error.newBuilder().setClassName(e.getClass().getName()).setErrorMessage(e.getMessage() == null ? e.toString() : e.getMessage()).setStackTrace(Exceptions.getStackTrace(e))));
        internalEvent.metaData.ifPresent(metadata -> {
            Messages.Metadata.Builder metaDataBuilder = Messages.Metadata.newBuilder();
            eventBuilder.addAllMetadata(metadata.stream().map(pair -> metaDataBuilder.setKey((String)pair.key).setValue((String)pair.value).build()).collect(Collectors.toList()));
        });
        internalEvent.payload.ifPresent(bytes -> eventBuilder.setPayload(ByteString.copyFrom((byte[])bytes)));
        return eventBuilder.build();
    }
}

