/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.internal;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObjectId
implements Comparable<ObjectId>,
Serializable {
    private static final long serialVersionUID = 3670079982654483072L;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int MACHINE_IDENTIFIER;
    private static final short PROCESS_IDENTIFIER;
    private static final AtomicInteger NEXT_COUNTER;
    private static final char[] HEX_CHARS;
    private final int timestamp;
    private final int machineIdentifier;
    private final short processIdentifier;
    private final int counter;

    public static ObjectId get() {
        return new ObjectId();
    }

    private static boolean isValid(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    private ObjectId() {
        this(LocalDateTime.now());
    }

    private ObjectId(LocalDateTime localDateTime) {
        this(ObjectId.localDateTimeToTimestampSeconds(localDateTime), MACHINE_IDENTIFIER, PROCESS_IDENTIFIER, NEXT_COUNTER.getAndIncrement(), false);
    }

    private ObjectId(int timestamp, int machineIdentifier, short processIdentifier, int counter, boolean checkCounter) {
        if ((machineIdentifier & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777215 (it must fit in three bytes).");
        }
        if (checkCounter && (counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        this.timestamp = timestamp;
        this.machineIdentifier = machineIdentifier;
        this.processIdentifier = processIdentifier;
        this.counter = counter & 0xFFFFFF;
    }

    public ObjectId(String hexString) {
        this(ObjectId.parseHexString(hexString));
    }

    private ObjectId(byte[] bytes) {
        this.timestamp = ObjectId.makeInt(bytes[0], bytes[1], bytes[2], bytes[3]);
        this.machineIdentifier = ObjectId.makeInt((byte)0, bytes[4], bytes[5], bytes[6]);
        this.processIdentifier = (short)ObjectId.makeInt((byte)0, (byte)0, bytes[7], bytes[8]);
        this.counter = ObjectId.makeInt((byte)0, bytes[9], bytes[10], bytes[11]);
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[]{ObjectId.int3(this.timestamp), ObjectId.int2(this.timestamp), ObjectId.int1(this.timestamp), ObjectId.int0(this.timestamp), ObjectId.int2(this.machineIdentifier), ObjectId.int1(this.machineIdentifier), ObjectId.int0(this.machineIdentifier), ObjectId.short1(this.processIdentifier), ObjectId.short0(this.processIdentifier), ObjectId.int2(this.counter), ObjectId.int1(this.counter), ObjectId.int0(this.counter)};
        return bytes;
    }

    public String toHexString() {
        char[] chars = new char[24];
        int i = 0;
        for (byte b : this.toByteArray()) {
            chars[i++] = HEX_CHARS[b >> 4 & 0xF];
            chars[i++] = HEX_CHARS[b & 0xF];
        }
        return new String(chars);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectId objectId = (ObjectId)o;
        return this.counter == objectId.counter && this.machineIdentifier == objectId.machineIdentifier && this.processIdentifier == objectId.processIdentifier && this.timestamp == objectId.timestamp;
    }

    public int hashCode() {
        int result = this.timestamp;
        result = 31 * result + this.machineIdentifier;
        result = 31 * result + this.processIdentifier;
        result = 31 * result + this.counter;
        return result;
    }

    @Override
    public int compareTo(ObjectId other) {
        if (other == null) {
            return 1;
        }
        byte[] byteArray = this.toByteArray();
        byte[] otherByteArray = other.toByteArray();
        for (int i = 0; i < 12; ++i) {
            if (byteArray[i] == otherByteArray[i]) continue;
            return (byteArray[i] & 0xFF) < (otherByteArray[i] & 0xFF) ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        return this.toHexString();
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(mac);
                try {
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Throwable t) {
            machinePiece = new SecureRandom().nextInt();
        }
        return machinePiece &= 0xFFFFFF;
    }

    private static short createProcessIdentifier() {
        short processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            processId = processName.contains("@") ? (short)Integer.parseInt(processName.substring(0, processName.indexOf(64))) : (short)ManagementFactory.getRuntimeMXBean().getName().hashCode();
        }
        catch (Throwable t) {
            processId = (short)new SecureRandom().nextInt();
        }
        return processId;
    }

    private static byte[] parseHexString(String s) {
        if (!ObjectId.isValid(s)) {
            throw new IllegalArgumentException("invalid hexadecimal representation of an ObjectId: [" + s + "]");
        }
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return b;
    }

    private static int localDateTimeToTimestampSeconds(LocalDateTime time) {
        return (int)(time.toInstant(ZoneOffset.UTC).toEpochMilli() / 1000L);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    static {
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MACHINE_IDENTIFIER = ObjectId.createMachineIdentifier();
            PROCESS_IDENTIFIER = ObjectId.createProcessIdentifier();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

