/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.mappers;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import net.soundvibe.reacto.errors.RuntimeProtocolBufferException;
import net.soundvibe.reacto.internal.InternalEvent;
import net.soundvibe.reacto.internal.MessageMappers;
import net.soundvibe.reacto.internal.proto.Messages;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.Event;

public interface Mappers {
    public static byte[] internalEventToBytes(InternalEvent internalEvent) {
        return MessageMappers.toProtoBufEvent(internalEvent).toByteArray();
    }

    public static byte[] commandToBytes(Command command) {
        return MessageMappers.toProtoBufCommand(command).toByteArray();
    }

    public static InternalEvent fromBytesToInternalEvent(byte[] bytes) {
        try {
            return MessageMappers.toInternalEvent(Messages.Event.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeProtocolBufferException("Cannot deserialize event from bytes: " + new String(bytes), e);
        }
    }

    public static Event fromInternalEvent(InternalEvent internalEvent) {
        return Event.create(internalEvent.name, internalEvent.metaData, internalEvent.payload);
    }

    public static Command fromBytesToCommand(byte[] bytes) {
        try {
            return MessageMappers.toCommand(Messages.Command.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeProtocolBufferException("Cannot deserialize command from bytes: " + new String(bytes), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<byte[]> exceptionToBytes(Throwable throwable) {
        try {
            Throwable throwable2 = null;
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                Optional<byte[]> optional;
                ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutputStream);
                Throwable throwable3 = null;
                try {
                    oos.writeObject(throwable);
                    optional = Optional.of(byteArrayOutputStream.toByteArray());
                }
                catch (Throwable throwable4) {
                    try {
                        try {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            Mappers.$closeResource(throwable3, oos);
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                }
                Mappers.$closeResource(throwable3, oos);
                return optional;
            }
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<Throwable> fromBytesToException(byte[] bytes) {
        try {
            Throwable throwable = null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
                Optional<Throwable> optional;
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                Throwable throwable2 = null;
                try {
                    optional = Optional.ofNullable(objectInputStream.readObject()).map(o -> (Throwable)o);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            Mappers.$closeResource(throwable2, objectInputStream);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                Mappers.$closeResource(throwable2, objectInputStream);
                return optional;
            }
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }
}

