/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.mappers.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.soundvibe.reacto.discovery.types.ServiceRecord;
import net.soundvibe.reacto.discovery.types.ServiceType;
import net.soundvibe.reacto.discovery.types.Status;
import net.soundvibe.reacto.mappers.CommandRegistryMapper;
import net.soundvibe.reacto.mappers.ServiceRegistryMapper;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.Event;
import net.soundvibe.reacto.types.TypedCommand;
import net.soundvibe.reacto.types.TypedEvent;
import net.soundvibe.reacto.types.json.JsonArray;
import net.soundvibe.reacto.types.json.JsonObject;

public final class JacksonMapper
implements ServiceRegistryMapper,
CommandRegistryMapper {
    private final ObjectMapper objectMapper;
    public static final ObjectMapper JSON = new ObjectMapper();

    public static String toJson(Object object) {
        try {
            return JSON.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T> T fromJson(String json, Class<T> aClass) {
        try {
            return (T)JSON.readValue(json, aClass);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JacksonMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static SimpleModule jsonTypesModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(JsonObject.class, (JsonSerializer)new JsonObject.JsonObjectSerializer());
        simpleModule.addSerializer(JsonArray.class, (JsonSerializer)new JsonArray.JsonArraySerializer());
        simpleModule.addDeserializer(JsonObject.class, (JsonDeserializer)new JsonObject.JsonObjectDeserializer());
        simpleModule.addDeserializer(JsonArray.class, (JsonDeserializer)new JsonArray.JsonArrayDeserializer());
        simpleModule.addDeserializer(ServiceRecord.class, (JsonDeserializer)new ServiceRecordDeserializer());
        return simpleModule;
    }

    @Override
    public <C, E> TypedCommand toCommand(C genericCommand, Class<? extends E> eventClass) {
        try {
            return TypedCommand.create(genericCommand.getClass(), eventClass, this.objectMapper.writeValueAsBytes(genericCommand));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Override
    public <E> E toGenericEvent(Event event, Class<? extends E> eventClass) {
        try {
            return (E)this.objectMapper.readValue(event.payload.orElseThrow(() -> new IllegalStateException("Payload is missing for " + event)), eventClass);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <C> C toGenericCommand(Command command, Class<? extends C> commandClass) {
        try {
            return (C)this.objectMapper.readValue(command.payload.orElseThrow(() -> new IllegalStateException("Payload is missing for " + command)), commandClass);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public <E> TypedEvent toEvent(E genericEvent) {
        try {
            return TypedEvent.create(genericEvent.getClass(), this.objectMapper.writeValueAsBytes(genericEvent));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    static {
        JSON.registerModule((Module)JacksonMapper.jsonTypesModule());
    }

    public static class ServiceRecordDeserializer
    extends JsonDeserializer<ServiceRecord> {
        private static final JavaType mapType = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class);

        private String getString(Map<String, Object> map, String key) {
            Object value = map.get(key);
            if (value instanceof String) {
                return (String)value;
            }
            return null;
        }

        private Status getStatus(Map<String, Object> map) {
            try {
                return Optional.ofNullable(map.get("status")).filter(o -> o instanceof String).map(o -> Status.valueOf((String)o)).orElse(Status.UNKNOWN);
            }
            catch (Throwable e) {
                return Status.UNKNOWN;
            }
        }

        private ServiceType getServiceType(Map<String, Object> map) {
            try {
                return Optional.ofNullable(map.get("type")).filter(o -> o instanceof String).map(o -> ServiceType.valueOf((String)o)).orElse(ServiceType.LOCAL);
            }
            catch (Throwable e) {
                return ServiceType.LOCAL;
            }
        }

        private JsonObject getObject(Map<String, Object> map, String key) {
            Object value = map.get(key);
            if (value instanceof Map) {
                return new JsonObject((Map)value);
            }
            if (value instanceof JsonObject) {
                return (JsonObject)value;
            }
            return JsonObject.empty();
        }

        public ServiceRecord deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Map map = (Map)ctxt.readValue(p, mapType);
            return ServiceRecord.create(this.getString(map, "name"), this.getStatus(map), this.getServiceType(map), this.getString(map, "registrationId"), this.getObject(map, "location"), this.getObject(map, "metadata"));
        }
    }
}

