/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.metric;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.soundvibe.reacto.metric.Metrics;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.CommandDescriptor;
import net.soundvibe.reacto.types.Pair;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ObserverMetric<T>
implements Subscriber<T> {
    private static final Map<CommandDescriptor, ObserverMetric> observers = new ConcurrentHashMap<CommandDescriptor, ObserverMetric>();
    public static final String NAME_METER_ON_NEXT = "Meter:Events";
    public static final String NAME_METER_ON_ERROR = "Meter:Errors";
    public static final String NAME_TIMER_COMMAND = "Timer:Commands";
    private final Meter onNextMeter;
    private final Meter errorMeter;
    private final Timer timer;

    public static <T> ObserverMetric<T> findObserver(Command command) {
        return observers.computeIfAbsent(CommandDescriptor.fromCommand(command), ObserverMetric::new);
    }

    private ObserverMetric(CommandDescriptor commandDescriptor) {
        this.onNextMeter = Metrics.REGISTRY.meter(ObserverMetric.getName(commandDescriptor, NAME_METER_ON_NEXT));
        this.errorMeter = Metrics.REGISTRY.meter(ObserverMetric.getName(commandDescriptor, NAME_METER_ON_ERROR));
        this.timer = Metrics.REGISTRY.timer(ObserverMetric.getName(commandDescriptor, NAME_TIMER_COMMAND));
    }

    public static String getName(CommandDescriptor descriptor, String name) {
        return descriptor.eventType.isEmpty() ? descriptor.commandType + ":" + name : descriptor.commandType + ":" + descriptor.eventType + ":" + name;
    }

    public Pair<ObserverMetric<T>, Timer.Context> startTimer() {
        return Pair.of(this, this.timer.time());
    }

    public void onError(Throwable throwable) {
        this.errorMeter.mark();
    }

    public void onComplete() {
    }

    public void onSubscribe(Subscription s) {
    }

    public void onNext(T o) {
        this.onNextMeter.mark();
    }
}

