/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.server;

import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import net.soundvibe.reacto.errors.CommandNotFound;
import net.soundvibe.reacto.mappers.Mappers;
import net.soundvibe.reacto.server.CommandRegistry;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.CommandDescriptor;
import net.soundvibe.reacto.types.Event;

public class CommandProcessor {
    private final CommandRegistry commands;

    public CommandProcessor(CommandRegistry commands) {
        this.commands = commands;
    }

    public Flowable<Event> process(byte[] bytes) {
        return Flowable.just((Object)bytes).map(Mappers::fromBytesToCommand).flatMap(this::process);
    }

    public Flowable<Event> process(Command command) {
        return Flowable.just((Object)command).concatMap(cmd -> this.commands.findCommand(CommandDescriptor.fromCommand(cmd)).map(commandExecutor -> commandExecutor.execute((Command)cmd)).orElseGet(() -> Flowable.error((Throwable)new CommandNotFound(cmd.name)))).subscribeOn(Schedulers.computation());
    }
}

